package com.yingxin.beijingvehicleflow.controller;

import com.yingxin.beijingvehicleflow.entity.FloatingPopulation;
import com.yingxin.beijingvehicleflow.response.Response;
import com.yingxin.beijingvehicleflow.service.FloatingPopulationServcie;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.text.SimpleDateFormat;
import java.util.Date;


/**
 * description //TODO
 *
 * @author 226
 * @version 1.0
 * @date 2020/2/24
 */
@RestController
@CrossOrigin
@RequestMapping("/bjapi/v1")
public class FloatingPopulationController {

    private static Logger LOGGER = LoggerFactory.getLogger(FloatingPopulationController.class);

    @Autowired
    private FloatingPopulationServcie populationServcie;

    @PostMapping("/float-population")
    public Response checkFloatingPopulation(@RequestBody FloatingPopulation floatingPopulation) {
        try {
            return populationServcie.checkFloatingPopulation(floatingPopulation);
        } catch (Exception e) {
            LOGGER.error("防疫人员扫码异常：", e);
            return Response.fail("UNKNOWN-ERROR","服务繁忙，请稍后重试。");
        }
    }


}
