package com.yingxin.beijingvehicleflow.service.impl;

import com.yingxin.beijingvehicleflow.constant.Const;
import com.yingxin.beijingvehicleflow.entity.IdentityInformation;
import com.yingxin.beijingvehicleflow.mapper.IdentityInformationMapper;
import com.yingxin.beijingvehicleflow.service.IdentityInformationService;
import com.yingxin.beijingvehicleflow.util.PicUtils;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

/**
 * description //TODO
 *
 * @author 226
 * @version 1.0
 * @date 2020/2/23
 */
@Service
public class IdentityInformationServiceImpl implements IdentityInformationService {

    private static Logger LOGGER = LoggerFactory.getLogger(IdentityInformationService.class);

    @Autowired
    private IdentityInformationMapper identityInformationMapper;

    @Override
    public int insertIdentityInfo(IdentityInformation identityInformation) {
        identityInformationMapper.insertIdentityInfo(identityInformation);
        return identityInformation.getId();
    }

    @Override
    public boolean isUpdateIdentityInfoSucc(IdentityInformation identityInformation) {
        identityInformation.setFaceImage(
                PicUtils.compressImage(identityInformation.getFaceImage(),
                        Const.FACE_IMG_SIZE));
        return identityInformationMapper.updateIdentityInfo(identityInformation) == 1;
    }

    @Override
    public JSONObject getwechatInfoByTempCode(String code) {
        BufferedReader in = null;
        String url = "https://api.weixin.qq.com/sns/jscode2session?appid=wxa0c404418dc92510" +
                "&secret=93f2470aa31ae319145b1216704262f6" +
                "&js_code="+code+
                "&grant_type=authorization_code";
        URL realUrl;
        try {
            realUrl = new URL(url);
        } catch (MalformedURLException e) {
            LOGGER.error("通过tempCode获取openId时，URL错误：", e);
            return null;
        }
        URLConnection connection;
        JSONObject jsonObject;
        try {
            connection = realUrl.openConnection();
            in = new BufferedReader(new InputStreamReader(
                    connection.getInputStream()));
            return JSONObject.fromObject(in.readLine());
        } catch (IOException e) {
            LOGGER.error("通过tempCode获取openId时，打开连接错误：", e);
            return null;
        } finally {
            try {
                if (in != null) {
                    in.close();
                }
            } catch (IOException e) {
                LOGGER.error("通过tempCode获取openId时，流关闭异常：", e);
            }
        }

//        return jsonObject.getString("openid");
    }

    @Override
    public IdentityInformation getAllInfoByOpenid(String openid) {
        return identityInformationMapper.getAllInfoByOpenid(openid);
    }

}
