package com.yingxin.beijingvehicleflow.mapper;

import com.yingxin.beijingvehicleflow.entity.Reservation;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.List;

/**
 * 数据库表单对应Mapper
 *
 * @author 226
 * @version 1.0
 * @date 2020/2/23
 */
@Mapper
public interface ReservationMapper {

    /**
     *  插入预约表中的所有的内容【在身份信息插入后】，除开认证时的时间还有坐标
     *
     * @date 2020/2/23
     * @param reservation 预约表信息
     * @return int
     */
    @Insert("insert into reservation(car_number,outset,destination,community_contact_name,community_contact_phone,submit_coordinate,submit_time,verify_state,identity_id) " +
            "values(#{carNumber},#{outset},#{destination},#{communityContactName},#{communityContactPhone},#{submitCoordinate},#{submitTime},#{verifyState},#{identityId}) ")
    int insertReservation(Reservation reservation);

    /**
     *  根据预约单的id来更新预约单生成二维码时的认证坐标和认证时间
     *
     * @date 2020/2/23
     * @param reservation 预约表信息【包括id,authCoordinate,authTime】
     * @return int
     */
    @Update("update reservation set auth_coordinate=#{authCoordinate},auth_time=#{authTime} where id = #{id}")
    int updateAuthInfo(Reservation reservation);

    @Select("select * ")
    List<Reservation> selectReservatinsByIdentityId(Reservation reservation);
}
