package com.yingxin.beijingvehicleflow.mapper;

import com.yingxin.beijingvehicleflow.entity.IdentityInformation;
import org.apache.ibatis.annotations.*;

/**
 * 数据库表单对应Mapper
 *
 * @author 226
 * @version 1.0
 * @date 2020/2/23
 */
@Mapper
public interface IdentityInformationMapper {

    /**
     *  第一次插入身份信息表，注册的时候【只插入wechatPhone，wechatOpenid】
     *
     * @date 2020/2/23
     * @param identityInformation 包含wechatPhone，wechatOpenid
     * @return int
     */
    @Insert("insert into identity_information(wechat_phone,wechat_openid) " +
            "values(#{wechatPhone},#{wechatOpenid})")
    @Options(useGeneratedKeys=true, keyProperty="id", keyColumn="id")
    int insertIdentityInfo(IdentityInformation identityInformation);

    /**
     *  预约表单提交的时候更新身份信息数据
     *
     * @date 2020/2/23
     * @param identityInformation 包含除了wechatPhone，wechatOpenid的所有信息
     * @return
     */
    @Update("update identity_information set name=#{name},id_card_number=#{idCardNumber}," +
            "phone_number=#{phoneNumber},face_image=#{faceImage},toBeijing_date=#{toBeijingDate}," +
            "is_worker=#{isWorker} where id =#{id}")
    int updateIdentityInfo(IdentityInformation identityInformation);

    @Select("select * from identity_information where wechat_openid = #{openid}")
    IdentityInformation getAllInfoByOpenid(String openid);
}
