package com.yingxin.beijingvehicleflow.controller;

import com.yingxin.beijingvehicleflow.entity.IdentityInformation;
import com.yingxin.beijingvehicleflow.response.Response;
import com.yingxin.beijingvehicleflow.service.IdentityInformationService;
import com.yingxin.beijingvehicleflow.util.AESUtil;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * description //TODO
 *
 * @author 226
 * @version 1.0
 * @date 2020/2/24
 */
@RestController
@CrossOrigin
@RequestMapping("/api/v1")
public class IdentityInfoController {

    private static Logger LOGGER = LoggerFactory.getLogger(IdentityInfoController.class);


    @Autowired
    private IdentityInformationService identityInformationService;

    /**
     *  根据tempCode去获取openId,然后在数据库中查看是否有与其相同的openId
     *
     * @date 2020/2/21
     * @param json {"code":""}
     * @return com.yingxin.covid19prevention.response.Response
     */
    @PostMapping("/identity/exist/state")
    public Response isIdentityInfoExist(@RequestBody String json) {

        JSONObject jsonObject = JSONObject.fromObject(json);
        JSONObject jsonAfterLogin = identityInformationService.getwechatInfoByTempCode(jsonObject.getString("code"));
        IdentityInformation info = identityInformationService.getAllInfoByOpenid(jsonAfterLogin.getString("openid"));
        if (info == null) {
            return Response.fail();
        }

        return new Response<IdentityInformation>(true,"","",info);
    }

    /**
     *  将获取到的加密手机号进行解密,将解密的手机号和获取到的openId一起存到用户表中,
     *
     * @date 2020/2/21
     * @param json code、iv、encryptedData
     * @return com.yingxin.covid19prevention.response.Response  userId
     */
    @PostMapping("/identity/wechat")
    public Response getDecryptData(@RequestBody String json) {
        JSONObject jsonObject = JSONObject.fromObject(json);
        String tempCode = jsonObject.getString("code");
        String iv = jsonObject.getString("iv");
        String encryptedData = jsonObject.getString("encryptedData");
        JSONObject loginJson = identityInformationService.getwechatInfoByTempCode(tempCode);
        String sessionKey = loginJson.getString("session_key");
        String result;
        try {
            result = AESUtil.decryptForWeChatApplet(encryptedData, sessionKey, iv);
        } catch (Exception e) {
            LOGGER.error("获取微信手机号码解密异常：", e);
            return Response.fail("Decrypt-ERROR", "获取微信手机号码解密异常");
        }

        JSONObject wechatJson;
        String weChatPhone;
        String openid;
        try {
            wechatJson = JSONObject.fromObject(result);
            weChatPhone = wechatJson.getString("phoneNumber");
            openid = loginJson.getString("openid");
        } catch (Exception e) {
            LOGGER.error("解密结果json解析异常", e);
            return Response.fail("JSON-PARSE-ERROR", "解密结果json解析异常");
        }

        IdentityInformation info = new IdentityInformation();
        info.setWechatPhone(weChatPhone);
        info.setWechatOpenid(openid);
        int resultAfterInsert = identityInformationService.insertIdentityInfo(info);
        if (resultAfterInsert > 0) {
            return new Response<Integer>(true,"","",resultAfterInsert);
        }

        return Response.fail();

    }

}
