package com.yingxin.beijingvehicleflow.util;

import net.sf.json.JSONObject;

import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import java.security.Key;
import java.util.Base64;

/**
 * @auther 李晓阳
 * @email lixy@yingxininfo.net
 * @date 2020/2/15 19:50
 */
public class DesUtil {
    /**
     * 偏移变量，固定占8位字节
     */
    private final static String IV_PARAMETER = "12345678";
    /**
     * 密钥算法
     */
    private static final String ALGORITHM = "DES";
    /**
     * 加密/解密算法-工作模式-填充模式
     */
    private static final String CIPHER_ALGORITHM = "DES/CBC/PKCS5Padding";
    /**
     * 默认编码
     */
    private static final String CHARSET = "utf-8";

    /**
     * 生成key
     *
     * @param password 密码
     * @return 返回密钥对象
     * @throws Exception
     */
    private static Key generateKey(String password) throws Exception {
        // 设置密钥参数
        DESKeySpec dks = new DESKeySpec(password.getBytes(CHARSET));
        //获得密钥工厂
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(ALGORITHM);
        return keyFactory.generateSecret(dks);
    }


    /**
     * DES加密字符串
     *
     * @param password 加密密码，长度不能够小于8位
     * @param data 待加密字符串
     * @return 加密后内容
     */
    public static String encrypt(String password, String data) {
        if (password== null || password.length() < 8) {
            throw new RuntimeException("加密失败，key不能小于8位");
        }
        if (data == null) {
            return null;
        }
        try {
            Key secretKey = generateKey(password);
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            // AlgorithmParameterSpec加密算法的参数接口，IvParameterSpec是它的一个实现
            //设置向量
            IvParameterSpec iv = new IvParameterSpec(IV_PARAMETER.getBytes(CHARSET));
            // 设置工作模式为加密模式，给出密钥和向量
            cipher.init(Cipher.ENCRYPT_MODE, secretKey, iv);
            byte[] bytes = cipher.doFinal(data.getBytes(CHARSET));
            //JDK1.8及以上可直接使用Base64，JDK1.7及以下可以使用BASE64Encoder
            return new String(Base64.getEncoder().encode(bytes));

        } catch (Exception e) {
            e.printStackTrace();
            return data;
        }
    }

    /**
     * DES解密字符串
     *
     * @param password 解密密码，长度不能够小于8位
     * @param data 待解密字符串
     * @return 解密后内容
     */
    public static String decrypt(String password, String data) {
        if (password== null || password.length() < 8) {
            throw new RuntimeException("加密失败，key不能小于8位");
        }
        if (data == null)
            return null;
        try {
            Key secretKey = generateKey(password);
            //得到加解密对象Cipher
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            //设置向量
            IvParameterSpec iv = new IvParameterSpec(IV_PARAMETER.getBytes(CHARSET));
            // 设置工作模式为解密模式，给出密钥和向量
            cipher.init(Cipher.DECRYPT_MODE, secretKey, iv);
            return new String(cipher.doFinal(Base64.getDecoder().decode(data.getBytes(CHARSET))), CHARSET);
        } catch (Exception e) {
            e.printStackTrace();
            return data;
        }
    }

    public static String transformObjectToJsonString(Object object) {
        return JSONObject.fromObject(object).toString();
    }

//    public static void main(String[] args) throws Exception {
//        String password = "sjskslscscsclksc";
//        String data = "{\"hello\":\"word\",\"what\":\"are you\"}";
//
//        JSONObject jsonObject = JSONObject.fromObject(Response.   fail());
//        String jsonToString = jsonObject.toString();
//
//        //加密
//        String encodeData = DesUtil.encrypt(password,jsonToString);
//        System.out.println("加密:" + encodeData);
//        //解密
//        String decodeData = DesUtil.decrypt(password,encodeData);
//        System.out.println("解密:" + decodeData);
//    }
}
