package com.yingxin.beijingvehicleflow.controller;

import com.yingxin.beijingvehicleflow.dto.ReservationInfoDTO;
import com.yingxin.beijingvehicleflow.entity.IdentityInformation;
import com.yingxin.beijingvehicleflow.entity.Reservation;
import com.yingxin.beijingvehicleflow.response.Response;
import com.yingxin.beijingvehicleflow.service.ReservationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * description //TODO
 *
 * @author 226
 * @version 1.0
 * @date 2020/2/23
 */
@RestController
@CrossOrigin
@RequestMapping("/bjapi/v1")
public class ReservationController {

    private static Logger LOGGER = LoggerFactory.getLogger(ReservationController.class);

    @Autowired
    private ReservationService reservationService;

    @PostMapping("/identity/reservation")
    public Response insertIdentityInfoAndReservation(@RequestBody ReservationInfoDTO info) {
        try {
            return reservationService.insertIdentityInfoAndReservation(info);
        } catch (Exception e) {
            LOGGER.error("预约表单提交接口异常：", e);
        }
        return Response.fail("UNKNOW-ERROR", "系统繁忙，请稍后重试。");
    }

    @PostMapping("/reservations")
    public Response selectNotVerifyReservatinsByIdentityId(@RequestBody IdentityInformation info) {
        List notVerifyReservationlist = reservationService.selectNotVerifyReservatinsByIdentityId(info);
        return notVerifyReservationlist.size()==0?Response.succ():Response.fail();
    }


}
