package com.yingxin.beijingvehicleflow.config;


import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;


/**
 * 异步相关定义
 *
 * @author zhangzhenbang
 * @version 1.0
 * @date 2020/1/8
 */
@Configuration
public class AsyncConfig implements AsyncConfigurer {

    @Value("${async-Config.MAX-POOL-SIZE}")
    private int maxPoolSize;

    @Value("${async-Config.CORE-POOL-SIZE}")
    private int corePoolSize;

    @Bean("asyncTaskExecutor")
    public AsyncTaskExecutor asyncTaskExecutor() {
        ThreadPoolTaskExecutor asyncTaskExecutor = new ThreadPoolTaskExecutor();
        asyncTaskExecutor.setMaxPoolSize(maxPoolSize);
        asyncTaskExecutor.setCorePoolSize(corePoolSize);
        asyncTaskExecutor.setThreadNamePrefix("async-task-thread-pool-");
        asyncTaskExecutor.initialize();
        return asyncTaskExecutor;
    }
}
