package com.yingxin.beijingvehicleflow.service.impl;

import com.yingxin.beijingvehicleflow.dto.ReservationInfoDTO;
import com.yingxin.beijingvehicleflow.entity.Reservation;
import com.yingxin.beijingvehicleflow.mapper.ReservationMapper;
import com.yingxin.beijingvehicleflow.response.Response;
import com.yingxin.beijingvehicleflow.service.IdentityInformationService;
import com.yingxin.beijingvehicleflow.service.ReservationService;
import com.yingxin.beijingvehicleflow.util.IdCardUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * description //TODO
 *
 * @author 226
 * @version 1.0
 * @date 2020/2/23
 */
@Service
public class ReservationServiceImpl implements ReservationService {

    @Autowired
    private ReservationMapper reservationMapper;

    @Autowired
    private IdentityInformationService identityService;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Response insertIdentityInfoAndReservation(ReservationInfoDTO info) throws Exception{

        String idCardNumber = info.getIdentityInformation().getIdCardNumber();

        if (!IdCardUtil.isValidatedAllIdcard(idCardNumber)) {
            return Response.fail("ERROR-ID-NUMBER", "身份证格式有误，请重新输入。");
        }

        if (identityService.isUpdateIdentityInfoSucc(info.getIdentityInformation()) &&
                isInsertReservationSucc(info.getReservation())) {
            return Response.succ();
        }

        return Response.fail();
    }

    @Override
    public boolean isInsertReservationSucc(Reservation reservation) {
        Date date =new Date ();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        reservation.setSubmitTime(sdf.format(date));
        return reservationMapper.insertReservation(reservation) == 1;
    }
}
