package com.yingxin.beijingvehicleflow.service.impl;

import com.yingxin.beijingvehicleflow.constant.Const;
import com.yingxin.beijingvehicleflow.entity.IdentityInformation;
import com.yingxin.beijingvehicleflow.mapper.IdentityInformationMapper;
import com.yingxin.beijingvehicleflow.service.IdentityInformationService;
import com.yingxin.beijingvehicleflow.util.PicUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * description //TODO
 *
 * @author 226
 * @version 1.0
 * @date 2020/2/23
 */
@Service
public class IdentityInformationServiceImpl implements IdentityInformationService {

    @Autowired
    private IdentityInformationMapper identityInformationMapper;

    @Override
    public int insertIdentityInfo(IdentityInformation identityInformation) {
        identityInformationMapper.insertIdentityInfo(identityInformation);
        return identityInformation.getId();
    }

    @Override
    public boolean isUpdateIdentityInfoSucc(IdentityInformation identityInformation) {
        identityInformation.setFaceImage(
                PicUtils.compressImage(identityInformation.getFaceImage(),
                        Const.FACE_IMG_SIZE));
        return identityInformationMapper.updateIdentityInfo(identityInformation) == 1;
    }
}
