package com.yingxin.beijingvehicleflow.response;

/**
 * 返回狀態類
 *
 * @author 226
 * @version 1.0
 * @date 2020/2/13
 */
public class Response<T> {

    private boolean status;
    private String code;
    private String msg;

    private T data;

    /*---------------------------常用構造器-----------------------------*/

    private Response() {

    }

    private Response(boolean status) {
        this.status = status;
    }

    private Response(boolean status, String code, String msg) {
        this.status = status;
        this.code = code;
        this.msg = msg;
    }

    public Response(boolean status, String code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.status = status;
        this.data = data;
    }

    /*---------------------------常用靜態方法-----------------------------*/

    public static Response fail() {
        return new Response(false);
    }

    public static Response fail(String code, String msg) {
        return new Response(false, code, msg);
    }

    public static Response succ() {
        return new Response(true);
    }

    public static Response succ(String code, String msg) {
        return new Response(true, code, msg);
    }

    /*---------------------------Getter & Setter-----------------------------*/

    public boolean isStatus() {
        return status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }
}
