package com.yxproject.start.service.impl;

import com.yxproject.start.entity.UserInfo;
import com.yxproject.start.mapper.SysRoleMapper;
import com.yxproject.start.mapper.UserInfoMapper;
import com.yxproject.start.service.UserInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author  liboyang
 */
@Service

public class UserInfoServiceImpl implements UserInfoService {

    @Autowired
    private UserInfoMapper userInfoMapper;
    @Autowired
    private SysRoleMapper sysRoleMapper;

    @Override
    public UserInfo findByUsername(String username) {

        UserInfo user = userInfoMapper.findUserByUsername(username);

        return user;
    }

    @Override
    @Transactional(rollbackFor=Exception.class)
    public boolean addUser(UserInfo userinfo, Integer roleId) {
        userInfoMapper.saveUserInfo(userinfo);
        if(roleId==-1){
            return true;
        }
        userInfoMapper.saveUserRole(userinfo.getId(),roleId);
        return true;
    }

    @Override
    public List<UserInfo> getAllUserInfo() {
        List<UserInfo>  list = userInfoMapper.selectAllUserInfo();
        return list;
    }

    @Override
    public boolean deleteUserInfo(Integer userId) {
        userInfoMapper.delUserInfo(userId);
        return true;
    }

    @Override
    public boolean BackUserInfo(Integer userId) {
        userInfoMapper.backUserInfo(userId);
        return true;
    }

    @Override
    public UserInfo getUserInfoByUserId(Integer userId) {
        UserInfo userInfo = userInfoMapper.selectUserInfoByUserId(userId);
        return userInfo;
    }

    @Override
    @Transactional(rollbackFor=Exception.class)
    public boolean updateUser(UserInfo userInfo, Integer roleId, Integer oldRoleId) {
        userInfoMapper.updateUserInfo(userInfo);
        if(roleId.equals(oldRoleId)){
            return true;
        }
        sysRoleMapper.updateUserRole(userInfo.getId(),roleId);
        return true;
    }



}
