package com.yxproject.start.service.impl;

import com.yxproject.start.entity.SysRole;
import com.yxproject.start.mapper.SysRoleMapper;
import com.yxproject.start.service.SysRoleService;
import net.sf.json.JSONArray;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author liboyang
 */
@Service
public class SysRoleServiceImpl implements SysRoleService {
    @Autowired
    private SysRoleMapper sysRoleMapper;
    @Override
    @Transactional(rollbackFor=Exception.class)
    public boolean addRole(SysRole sysRole, JSONArray jsonArray) {
        sysRoleMapper.addRoleByMap(sysRole);
        Integer roleId = sysRole.getId();
        for (Object object:jsonArray){
            sysRoleMapper.addRolePermission(roleId,Integer.parseInt(object.toString()));
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor=Exception.class)
    public boolean updateRole(SysRole sysRole, JSONArray ids, JSONArray oldIds) {
        sysRoleMapper.updateSysRole(sysRole);
        for (Object object:oldIds){
            sysRoleMapper.delRolePermission(sysRole.getId(),Integer.parseInt(object.toString()));
        }
        for (Object object:ids){
            sysRoleMapper.addRolePermission(sysRole.getId(),Integer.parseInt(object.toString()));
        }
        return true;
    }


    @Override
    public List<SysRole> getAllRoleInfo() {
        List<SysRole> list = sysRoleMapper.selectAllRole();
        return list;
    }

    @Override
    public List<SysRole> getAllActiveRoleInfo() {
        List<SysRole> list = sysRoleMapper.selectAllActiveRole();
        return list;
    }

    @Override
    public boolean deleteRole(Integer roleId) {
        sysRoleMapper.delRole(roleId);
        return true;
    }

    @Override
    public boolean backRole(Integer roleId) {
        sysRoleMapper.backRole(roleId);
        return true;
    }

    @Override
    public SysRole getRoleByRoleId(Integer roleId) {
        SysRole sysRole = sysRoleMapper.selectRoleByRoleId(roleId);
        return sysRole;
    }


}
