package com.yxproject.start.service.impl;

import com.yxproject.start.dto.CardsStatusAndCardsMsgDto;
import com.yxproject.start.dto.CardsStatusAndPostMsgDto;
import com.yxproject.start.mapper.PersonalProgressStatusMapper;
import com.yxproject.start.service.PersonalProgressStatusService;
import net.sf.json.JSONArray;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

/**
 * @author Administrator
 */
@Service
public class PersonalProgressStatusServiceImpl implements PersonalProgressStatusService {

    @Autowired
    private PersonalProgressStatusMapper personalProgressStatusMapper;
    @Override
    public List<CardsStatusAndPostMsgDto> getStatusAndPostMsg(String date, String police) {
        List<CardsStatusAndPostMsgDto> list = personalProgressStatusMapper.selectStatusAndPostMsg(date,police);
        return list;
    }

    @Override
    public List<CardsStatusAndCardsMsgDto> getStatusAndCardMsg(String date, String police) {
        List<CardsStatusAndCardsMsgDto> list = personalProgressStatusMapper.selectStatusAndCardMsg(date,police);
        return list;
    }

    @Override
    @Transactional(rollbackFor=Exception.class)
    public boolean updateSignInDate(JSONArray jsonArray) {
        for (Object object:jsonArray){
            personalProgressStatusMapper.updateSignInDate(object.toString());
        }
        return true;
    }
}
