package com.yxproject.start.service;

import com.yxproject.start.entity.UserInfo;

import java.util.List;

/**
 * @author liboyang
 */
public interface UserInfoService{

    /**
     * 查询用户
     * @param username
     * @return
     */
    public UserInfo findByUsername(String username);

    /**
     * 新增用户
     * @param userinfo
     * @param roleId
     * @return
     */
    public boolean addUser(UserInfo userinfo, Integer roleId);

    /**
     * 查询所有用户
     * @return
     */
    public List<UserInfo> getAllUserInfo();

    /**
     * 删除用户
     * @param userId
     * @return
     */
    public boolean deleteUserInfo(Integer userId);

    /**
     * 启用用户
     * @param userId
     * @return
     */
    public boolean BackUserInfo(Integer userId);

    /**
     * 通过用户id查询用户和角色
     * @param userId
     * @return
     */
    public UserInfo getUserInfoByUserId(Integer userId);

    /**
     * 更新用户
     * @param userInfo
     * @param roleId
     * @return
     */
    public boolean updateUser(UserInfo userInfo, Integer roleId, Integer oldRoleId);

//    int delUsername( UserInfo userInfo);
//    int updateUsername(UserInfo userInfo);
}
