package com.yxproject.start.service;

import com.yxproject.start.entity.SysRole;
import net.sf.json.JSONArray;

import java.util.List;

/**
 * @author liboyang
 */
public interface SysRoleService {
    /**
     * 添加角色并分配权限
     * @param sysRole
     * @param jsonArray
     * @return
     */
    public boolean addRole(SysRole sysRole, JSONArray jsonArray);

    /**
     * 修改角色和权限
     * @param sysRole
     * @param ids
     * @param oldIds
     * @return
     */

    public boolean updateRole(SysRole sysRole, JSONArray ids, JSONArray oldIds);

    /**
     * 查询所有角色
     * @return
     */
    public List<SysRole> getAllRoleInfo();

    /**
     * 查询所有可用的角色
     * @return
     */
    public List<SysRole> getAllActiveRoleInfo();

    /**
     * 删除角色
     * @param roleId
     * @return
     */
    public boolean deleteRole(Integer roleId);

    /**
     * 启用角色
     * @param roleId
     * @return
     */
    public boolean backRole(Integer roleId);

    /**
     * 通过角色id查询角色和权限
     * @param roleId
     * @return
     */
    public SysRole getRoleByRoleId(Integer roleId);
}
