package com.yxproject.start.mapper;

import com.yxproject.start.entity.UserInfo;
import org.apache.ibatis.annotations.*;

import java.util.List;

/**
 * @author liboyang
 */
@Mapper
public interface UserInfoMapper {


    /**
     * 通过用户名查询用户信息
     * @param username
     * @return
     */
    @Select("select * from USER_INFO where username=#{username}")
    @Results({@Result(property = "id",column = "id"),
            @Result(property = "username",column = "username"),
            @Result(property = "name",column = "name"),
            @Result(property = "password",column = "password"),
            @Result(property = "salt",column = "salt"),
            @Result(property = "state",column = "state"),
            @Result(property = "roleList",javaType = List.class,column ="id",
                    many = @Many(select = "com.yxproject.start.mapper.SysRoleMapper.selectRoleAndPermissionByUserId"))})
    public UserInfo findUserByUsername(String username);


    /**
     * 新增用户
     * @param userinfo
     * @return
     */
    @Insert("INSERT INTO USER_INFO(ID, NAME, PASSWORD, STATE, USERNAME, SALT) " +
            "VALUES(USER_INFO_seq.nextval,#{name},#{password},0,#{username},#{salt})\n")
    @Options(useGeneratedKeys = true, keyProperty = "id",keyColumn = "id")
    public void saveUserInfo(UserInfo userinfo);

    /**
     * 添加用户角色关系表
     * @param userId
     * @param roleId
     */
    @Insert("INSERT INTO SYS_USER_ROLE(USER_ID,ROLE_ID)VALUES(#{userId},#{roleId})\n")
    public void saveUserRole(@Param("userId") Integer userId, @Param("roleId") Integer roleId);

    /**
     * 查询所有用户
     * @return
     */
    @Select("select * from USER_INFO")
    @Results({@Result(property = "id",column = "id"),
            @Result(property = "username",column = "username"),
            @Result(property = "name",column = "name"),
            @Result(property = "password",column = "password"),
            @Result(property = "salt",column = "salt"),
            @Result(property = "state",column = "state"),
            @Result(property = "roleList",javaType = List.class,column ="id",
                    many = @Many(select = "com.yxproject.start.mapper.SysRoleMapper.selectRoleAndPermissionByUserId"))})
    public List<UserInfo> selectAllUserInfo();


    /**
     * 通过id查询用户
     * @param userId
     * @return
     */
    @Select("select * from USER_INFO WHERE id=#{userId}")
    @Results({@Result(property = "id",column = "id"),
            @Result(property = "username",column = "username"),
            @Result(property = "name",column = "name"),
            @Result(property = "password",column = "password"),
            @Result(property = "salt",column = "salt"),
            @Result(property = "state",column = "state"),
            @Result(property = "roleList",javaType = List.class,column ="id",
                    many = @Many(select = "com.yxproject.start.mapper.SysRoleMapper.selectRoleByUserId"))})
    public UserInfo selectUserInfoByUserId(@Param("userId") Integer userId);


    /**
     * 删除用户
     * @param userId
     */
    @Update("UPDATE USER_INFO SET STATE = 1 WHERE ID=#{userId}")
    public void delUserInfo(@Param("userId") Integer userId);

    /**
     * 启用用户
     * @param userId
     */
    @Update("UPDATE USER_INFO SET STATE = 0 WHERE ID=#{userId}")
    public void backUserInfo(@Param("userId") Integer userId);

    /**
     * 更新用户
     * @param userInfo
     */
    @Update("UPDATE USER_INFO SET USERNAME=#{username},NAME=#{name} where ID=#{id}")
    public void updateUserInfo(UserInfo userInfo);
}


