package com.yxproject.start.mapper;

import com.yxproject.start.entity.SysPermission;
import org.apache.ibatis.annotations.*;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * @author Administrator
 */
@Mapper
public interface SysPermissionMapper{
    /**
     * 新增权限
     * @param sysPermission
     */
    @Insert("INSERT INTO sys_permission (id,available,name,parent_id,parent_ids,permission,resource_type,url)\n" +
            "VALUES (PERMISSION_seq.nextval,0,#{name},'0','0/',#{permission},#{resource_type},#{url})")
    public void addPermissionByMap(SysPermission sysPermission);

    /**
     * 查询所有可用权限
     * @return
     */
    @Select("select * from SYS_PERMISSION where available=0")
    public List<SysPermission> selectAllActivePermission();

    /**
     * 查询所有权限
     * @return
     */
    @Select("select * from SYS_PERMISSION")
    public List<SysPermission> selectAllPermission();

    /**
     * 删除权限
     * @param permissionId
     */
    @Update("UPDATE SYS_PERMISSION SET AVAILABLE = 1 WHERE ID=#{permissionId}")
    public void delPermission(@Param("permissionId") Integer permissionId);

    /**
     * 启用权限
     * @param permissionId
     */
    @Update("UPDATE SYS_PERMISSION SET AVAILABLE = 0 WHERE ID=#{permissionId}")
    public void backPermission(@Param("permissionId") Integer permissionId);

    /**
     * 通过角色id查询权限
     * @param roleId
     * @return
     */
    @Select("select * from SYS_ROLE_PERMISSION srp ,SYS_PERMISSION sp where srp.PERMISSION_ID=sp.ID and srp.ROLE_ID=#{roleId}")
    public List<SysPermission> selectPermissionByRoleId(@Param("roleId") Integer roleId);

    /**
     *通过id查询权限信息
     * @param permissionId
     * @return
     */
    @Select("select * from SYS_PERMISSION WHERE ID=#{permissionId}")
    public SysPermission selectPermissionByPid(@Param("permissionId") Integer permissionId);

    /**
     * 通过父id查询父名称
     * @param parentId
     * @return
     */
    @Select("select name from SYS_PERMISSION WHERE ID=#{parentId}")
    public String selectParentNameById(@Param("parentId") Long parentId);

    /**
     * 修改权限信息
     * @param sysPermission
     */
    @Update("update SYS_PERMISSION SET NAME=#{name},resource_type=#{resource_type},url=#{url}," +
            "permission=#{permission} where id=#{id}")
    public void updatePermission(SysPermission sysPermission);
}
