package com.yxproject.start.mapper;

import com.yxproject.start.dto.CardsStatusAndCardsMsgDto;
import com.yxproject.start.dto.CardsStatusAndPostMsgDto;
import com.yxproject.start.entity.PersonalProgressStatusEntity;
import org.apache.ibatis.annotations.*;

import java.util.List;
import java.util.Map;

/**
 * @author Administrator
 */
@Mapper
public interface PersonalProgressStatusMapper {

    /**
     * 查询证件状态和邮寄详情
     * @param police
     * @param date
     * @return
     */
    @Select("SELECT * FROM PERSONAL_PROGRESS_STATUS a LEFT JOIN PERSON_POST b ON a.UPLOAD_NO = b.FIRST_WHITE WHERE substr(a.UPLOAD_NO,0,9) = #{police} AND a.UPLOAD_NO LIKE CONCAT(CONCAT('%',#{date}),'%')")
    public List<CardsStatusAndPostMsgDto> selectStatusAndPostMsg(@Param("date")String date, @Param("police")String police);

    /**
     * 查询上传信息
     * @param police
     * @param date
     * @return
     */
    @Select("SELECT * FROM PERSONAL_PROGRESS_STATUS a LEFT JOIN PREPRO_PERSON b ON a.UPLOAD_NO = b.JMSFZSLH WHERE IMPORT_DATE=#{date} AND substr(a.UPLOAD_NO,0,9) = #{police}")
    public List<CardsStatusAndCardsMsgDto> selectStatusAndCardMsg(@Param("date")String date, @Param("police")String police);


    @Update("UPDATE PERSONAL_PROGRESS_STATUS SET PROGRESS_STATUS=9 WHERE UPLOAD_NO=#{uploadNo}")
    void updateSignInDate(@Param("uploadNo")String uploadNo);
}
