package com.yxproject.start.entity;

import javax.persistence.*;
import java.util.Objects;

@Entity
@Table(name = "TEMPORARY_CERTIFICATE", schema = "POST", catalog = "")
public class TemporaryCertificateEntity {
    private String temporaryCertificateId;
    private String name;
    private String cardId;
    private String phone;
    private String lastDurationOfStatus;
    private String receiptDate;
    private String dateOfHandOverToTreat;
    private String backWorkshopDate;
    private String deliverToParty;
    private String note;

    @Id
    @Column(name = "TEMPORARY_CERTIFICATE_ID")
    public String getTemporaryCertificateId() {
        return temporaryCertificateId;
    }

    public void setTemporaryCertificateId(String temporaryCertificateId) {
        this.temporaryCertificateId = temporaryCertificateId;
    }

    @Basic
    @Column(name = "NAME")
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Basic
    @Column(name = "CARD_ID")
    public String getCardId() {
        return cardId;
    }

    public void setCardId(String cardId) {
        this.cardId = cardId;
    }

    @Basic
    @Column(name = "PHONE")
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    @Basic
    @Column(name = "LAST_DURATION_OF_STATUS")
    public String getLastDurationOfStatus() {
        return lastDurationOfStatus;
    }

    public void setLastDurationOfStatus(String lastDurationOfStatus) {
        this.lastDurationOfStatus = lastDurationOfStatus;
    }

    @Basic
    @Column(name = "RECEIPT_DATE")
    public String getReceiptDate() {
        return receiptDate;
    }

    public void setReceiptDate(String receiptDate) {
        this.receiptDate = receiptDate;
    }

    @Basic
    @Column(name = "DATE_OF_HAND_OVER_TO_TREAT")
    public String getDateOfHandOverToTreat() {
        return dateOfHandOverToTreat;
    }

    public void setDateOfHandOverToTreat(String dateOfHandOverToTreat) {
        this.dateOfHandOverToTreat = dateOfHandOverToTreat;
    }

    @Basic
    @Column(name = "BACK_WORKSHOP_DATE")
    public String getBackWorkshopDate() {
        return backWorkshopDate;
    }

    public void setBackWorkshopDate(String backWorkshopDate) {
        this.backWorkshopDate = backWorkshopDate;
    }

    @Basic
    @Column(name = "DELIVER_TO_PARTY")
    public String getDeliverToParty() {
        return deliverToParty;
    }

    public void setDeliverToParty(String deliverToParty) {
        this.deliverToParty = deliverToParty;
    }

    @Basic
    @Column(name = "NOTE")
    public String getNote() {
        return note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TemporaryCertificateEntity that = (TemporaryCertificateEntity) o;
        return Objects.equals(temporaryCertificateId, that.temporaryCertificateId) &&
                Objects.equals(name, that.name) &&
                Objects.equals(cardId, that.cardId) &&
                Objects.equals(phone, that.phone) &&
                Objects.equals(lastDurationOfStatus, that.lastDurationOfStatus) &&
                Objects.equals(receiptDate, that.receiptDate) &&
                Objects.equals(dateOfHandOverToTreat, that.dateOfHandOverToTreat) &&
                Objects.equals(backWorkshopDate, that.backWorkshopDate) &&
                Objects.equals(deliverToParty, that.deliverToParty) &&
                Objects.equals(note, that.note);
    }

    @Override
    public int hashCode() {
        return Objects.hash(temporaryCertificateId, name, cardId, phone, lastDurationOfStatus, receiptDate, dateOfHandOverToTreat, backWorkshopDate, deliverToParty, note);
    }
}
