package com.yxproject.start.api;

import com.yxproject.start.dto.CardsStatusAndCardsMsgDto;
import com.yxproject.start.dto.CardsStatusAndPostMsgDto;
import com.yxproject.start.entity.PersonPostAbnormalEntity;
import com.yxproject.start.entity.PersonPostEntity;
import com.yxproject.start.entity.PersonalProgressStatusEntity;
import com.yxproject.start.service.PersonPostAbnormalService;
import com.yxproject.start.service.PersonPostService;
import com.yxproject.start.service.PersonalProgressStatusService;
import net.sf.json.JSONArray;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Administrator
 */
@RestController
@RequestMapping("api")
public class BizApi {

    @Autowired
    private PersonPostAbnormalService personPostAbnormalService;
    @Autowired
    private PersonalProgressStatusService personalProgressStatusService;
    @Autowired
    private PersonPostService personPostService;

    /**
     * 查询个人邮寄信息异常数据
     * @param date
     * @param police
     * @return
     */
    @RequestMapping("getErrorPostMsg")
    public List<PersonPostAbnormalEntity> getErrorPostMsg(@RequestParam("date")String date, @RequestParam("police")String police) {
        List<PersonPostAbnormalEntity> list  = personPostAbnormalService.getPersonPostAbnormal(date,police);
        return list;
    }

    /**
     * 查询对公邮寄包查询
     * @param date
     * @param police
     * @return
     */
    @RequestMapping("getCardsPostMsg")
    public List<CardsStatusAndPostMsgDto> getCardsPostMsg(@RequestParam("date")String date, @RequestParam("police")String police) {
        List<CardsStatusAndPostMsgDto> list  = personalProgressStatusService.getStatusAndPostMsg(date,police);
        return list;
    }

    /**
     * 通过运单号查询邮寄信息
     * @param waybillNumber
     * @return
     */
    @RequestMapping("getPostMsgByWaybillNo")
    public PersonPostEntity getPostMsgByWaybillNo(@RequestParam("waybillNumber")String waybillNumber) {
        PersonPostEntity personPostEntity  = personPostService.getPersonPostMsg(waybillNumber);
        return personPostEntity;
    }

    /**
     *查询个人证件信息和证件状态
     * @param date
     * @param police
     * @return
     */
    @RequestMapping("getCardsStatusAndCardMsg")
    public List<CardsStatusAndCardsMsgDto> getCardsStatusAndCardMsg(@RequestParam("date")String date, @RequestParam("police")String police) {
        List<CardsStatusAndCardsMsgDto> list  = personalProgressStatusService.getStatusAndCardMsg(date,police);
        return list;
    }

    /**
     * 签收(修改状态表中的状态)
     * @param uploadNoList
     * @return
     */
    @RequestMapping("setSignInDate")
    public Map<String,String> setSignInDate(@RequestBody String uploadNoList) {

        Map<String,String> map = new HashMap<>();
        JSONArray jsonArray = JSONArray.fromObject(uploadNoList);
        Boolean flag  = personalProgressStatusService.updateSignInDate(jsonArray);
        if(flag){
            map.put("msg","修改成功");
        }else {
            map.put("msg","修改失败");
        }
        return map;
    }


}
