app.controller('userListCtrl', ['$scope', '$rootScope', '$http', '$state', '$filter', '$localStorage', 'ngDialog', 'HttpService',
    function ($scope, $rootScope, $http, $state, $filter, $localStorage, ngDialog, HttpService) {

        if ($rootScope.loginData.login === false) {
            $state.go("signin")
        } else {
            $state.go("layout.userList")
        }
        $scope.id = 'id';
        // 用户列表
        var getUserList = function () {
            HttpService.getUserListData(function (data) {
                $scope.userList = data;
                console.log($scope.userList);
            })
        }
        getUserList();

        // 添加
        $scope.addUser = function () {
            ngDialog.open({
                template: 'dialogs/addUser.html' + urlTimeStamp(),
                width: 800,
                cache: false,
                closeByDocument: false,
                controller: ['$scope', 'HttpService', '$rootScope', function ($scope, HttpService) {
                    HttpService.getAllActiveRoleList(function (data) {
                        $scope.activeRoleList = data;
                    })
                    $scope.userAdd = function (roleId) {
                        var user = {};
                        user.username = $scope.username;
                        user.name = $scope.name;
                        user.password = $scope.password;
                        user.roleId = roleId;
                        HttpService.addUser(user, function (data) {
                            $scope.closeThisDialog();
                            getUserList();
                        })
                    }

                }]

            })
        }

        // 删除
        $scope.delUser = function (id) {
            HttpService.userDelete(id, function (data) {
                getUserList();
            })
        }

        // 启用
        $scope.openUser = function (id) {
            HttpService.userOpen(id, function (data) {
                getUserList();
            })
        }

        // 修改
        $scope.updateUser = function (id) {
            ngDialog.open({
                template: 'dialogs/updateUser.html' + urlTimeStamp(),
                width: 800,
                cache: false,
                closeByDocument: false,
                controller: ['$scope', 'HttpService', '$rootScope', function ($scope, HttpService) {
                    HttpService.getUserById(id, function (data) {
                        $scope.thisUser = data.user;
                        console.log($scope.thisUser)
                    })
                    HttpService.getAllActiveRoleList(function (data) {
                        $scope.activeRoleList = data;
                    })
                    $scope.userUpdate = function (roleId) {
                        var jsonUser = {};
                        jsonUser.username = $scope.thisUser.username;
                        jsonUser.name = $scope.thisUser.name;
                        jsonUser.id = $scope.thisUser.id;
                        jsonUser.oldRoleId = $scope.thisUser.roleList[0].id;
                        jsonUser.roleId = roleId;
                        console.log(jsonUser)
                        HttpService.updateUser(jsonUser, function (data) {
                            $scope.closeThisDialog();
                            getUserList();
                        })
                    }
                }]

            })

        }

    }])