package com.yxproject.start.utils;

import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.omg.CORBA.Any;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by yuzhanyang on 17/6/8.
 */
public class YXJSONResponse {

    private long ServerProcessingDur = 0;
    private long start_stamp;
    private long ServerProcessingFinishStamp = 0;
    public boolean Error = false;
    public String ReturnCode = "PASS";
    private String ReturnMsg = "PASS_DESC";
    public JSON RespData = null;

    /**
     * 构造方法 设定返回值对象的开始时间戳
     */
    public YXJSONResponse() {
        this.start_stamp = System.currentTimeMillis();
    }

    /**
     * 返回一个只有起止时间的空返回值对象
     * @return 返回值对象
     */
    public YXJSONResponse outPutSuccess() {
        this.ServerProcessingFinishStamp = System.currentTimeMillis();
        this.ServerProcessingDur = this.ServerProcessingFinishStamp - this.start_stamp;
        this.Error = false;
        return this;
    }

    /**
     * 通过map设定返回JSON
     * @param dataMap map类型的返回值
     * @return 返回值对象
     */
    public YXJSONResponse outPutSuccess(Map dataMap) {
        this.ServerProcessingFinishStamp = System.currentTimeMillis();
        this.ServerProcessingDur = this.ServerProcessingFinishStamp - this.start_stamp;
        this.Error = false;
        this.RespData = JSONObject.fromObject(dataMap);
        return this;
    }

    /**
     * 通过list设定返回JSON
     * @param dataList list类型的返回值
     * @return 返回值对象
     */
    public YXJSONResponse outPutSuccess(List dataList) {
        this.ServerProcessingFinishStamp = System.currentTimeMillis();
        this.ServerProcessingDur = this.ServerProcessingFinishStamp - this.start_stamp;
        this.Error = false;
        this.RespData = JSONArray.fromObject(dataList);
        return this;
    }

    /**
     * 通过json设定返回值
     * @param json json类型的返回值
     * @return 返回值对象
     */
    public YXJSONResponse outPutSuccessJSON(JSON json) {
        this.ServerProcessingFinishStamp = System.currentTimeMillis();
        this.ServerProcessingDur = this.ServerProcessingFinishStamp - this.start_stamp;
        this.Error = false;
        this.RespData = json;
        return this;
    }

    /**
     * 通过String设定返回值
     * @param string String类型的返回值
     * @return 返回值对象
     */
    public YXJSONResponse outPutSuccess(String string) {
        this.ServerProcessingFinishStamp = System.currentTimeMillis();
        this.ServerProcessingDur = this.ServerProcessingFinishStamp - this.start_stamp;
        this.Error = false;
        HashMap map = new HashMap<String, Any>();
        map.put("string", string);
        this.RespData = JSONObject.fromObject(map);
        return this;
    }

    /**
     * 设定出错返回值
     * @param returnCode 错误码
     * @param returnMsg 错误信息
     * @return 返回值对象
     */
    public YXJSONResponse outPutError(String returnCode, String returnMsg) {
        this.ServerProcessingFinishStamp = System.currentTimeMillis();
        this.ServerProcessingDur = this.ServerProcessingFinishStamp - this.start_stamp;
        this.ReturnCode = returnCode;
        this.ReturnMsg = returnMsg;
        this.Error = true;
        return this;
    }

    private JSONObject toJSON() {
        HashMap map = new HashMap<String, Any>();
        map.put("ServerProcessingDur", this.ServerProcessingDur);
        map.put("ServerProcessingFinishStamp", this.ServerProcessingFinishStamp);
        map.put("ReturnCode", this.ReturnCode);
        map.put("ReturnMsg", this.ReturnMsg);
        map.put("Error", this.Error);
        map.put("respData", this.RespData);
        return JSONObject.fromObject(map);
    }

    public String toJSONString() {
        return this.toJSON().toString();
    }


}
