package com.yxproject.start.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;

import org.apache.shiro.crypto.hash.SimpleHash;
import org.apache.shiro.util.ByteSource;



/**
 * 工具类
 * @author itdragon
 *
 */
public class Md5Utils {
	
	private static final String ALGORITHM_NAME = "MD5";
	private static final Integer HASH_ITERATIONS = 1024;
	
	/**
	 * 加盐加密的策略非常多,根据实际业务来
	 */
	public static String entryptPassword(String password,String salt) {
		Object md5Password = new SimpleHash(ALGORITHM_NAME, password, ByteSource.Util.bytes(salt), HASH_ITERATIONS);
		return md5Password.toString();
	}
	
	public static String getCurrentDateTime() {
		TimeZone zone = TimeZone.getTimeZone("Asia/Beijing");
		TimeZone.setDefault(zone);
		SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		return df.format(new Date());
	}

	public static void main(String[] args){
		String salt = UUID.randomUUID().toString();
		String pass = Md5Utils.entryptPassword("123456",salt);
		System.out.println(pass);
		System.out.println(salt);

	}

}
