package com.yxproject.start.service.impl;

import com.yxproject.start.entity.SysPermission;
import com.yxproject.start.mapper.SysPermissionMapper;
import com.yxproject.start.service.SysPermissionService;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * @author Administrator
 */
@Service
public class SysPermissionServiceImpl implements SysPermissionService{

    @Autowired
    private SysPermissionMapper sysPermissionMapper;

    @Override
    public boolean addPermission(SysPermission sysPermission) {
        sysPermissionMapper.addPermissionByMap(sysPermission);
        return true;
    }

    @Override
    public List<SysPermission> getAllActivePermission() {
        List<SysPermission> list = sysPermissionMapper.selectAllActivePermission();
        return list;
    }
    @Override
    public List<SysPermission> getAllPermission() {
        List<SysPermission> list = sysPermissionMapper.selectAllPermission();
        return list;
    }


    @Override
    public boolean deletePermission(Integer permissionId) {
        sysPermissionMapper.delPermission(permissionId);
        return true;
    }

    @Override
    public boolean backPermission(Integer permissionId) {
        sysPermissionMapper.backPermission(permissionId);
        return true;
    }

    @Override
    public SysPermission getPermissionByPId(Integer permissionId) {
        SysPermission sysPermission = sysPermissionMapper.selectPermissionByPid(permissionId);
        return sysPermission;
    }

    @Override
    public String getParentNameByParentId(Long parentId) {
        String parentName = sysPermissionMapper.selectParentNameById(parentId);
        return parentName;
    }

    @Override
    public boolean updatePermission(SysPermission sysPermission) {
        sysPermissionMapper.updatePermission(sysPermission);
        return true;
    }


}
