package com.yxproject.start.service;


import com.yxproject.start.entity.SysPermission;

import java.util.List;
import java.util.Map;

public interface SysPermissionService {

    /**
     * 新增权限
     * @param sysPermission
     * @return
     */
    public boolean addPermission(SysPermission sysPermission);

    /**
     * 查询所有权限
     * @return
     */
    public List<SysPermission> getAllPermission();

    /**
     * 查询所有可用权限
     * @return
     */
    public List<SysPermission> getAllActivePermission();

    /**
     * 删除权限
     * @param permissionId
     * @return
     */
    public boolean deletePermission(Integer permissionId);

    /**
     * 启用权限
     * @param permissionId
     * @return
     */
    public boolean backPermission(Integer permissionId);

    /**
     * 通过权限id查询权限
     * @param permissionId
     * @return
     */
    public SysPermission getPermissionByPId(Integer permissionId);

    /**
     * 通过父id查询父名称
     * @param parentId
     * @return
     */
    public String getParentNameByParentId(Long parentId);

    /**
     * 修改权限信息
     * @param sysPermission
     * @return
     */
    public boolean updatePermission(SysPermission sysPermission);
}

