package com.yxproject.start.mapper;

import com.yxproject.start.entity.SysRole;
import org.apache.ibatis.annotations.*;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author liboyang
 */
@Mapper
public interface SysRoleMapper {
    /**
     * 添加角色
     * @param sysRole
     */
    @Insert("INSERT INTO SYS_ROLE(ID,AVAILABLE,DESCRIPTION,ROLE)\n" +
            "VALUES(PERMISSION_seq.nextval,0,#{description},#{role})")
    @Options(useGeneratedKeys = true, keyProperty = "id",keyColumn = "id")
    public void addRoleByMap(SysRole sysRole);

    /**
     * 添加角色和权限
     * @param roleId
     * @param permissionId
     */
    @Insert("INSERT INTO SYS_ROLE_PERMISSION(ROLE_ID,PERMISSION_ID)VALUES(#{roleId},#{permissionId})")
    public void addRolePermission(@Param("roleId")Integer roleId,@Param("permissionId") Integer permissionId);

    /**
     * 查询所有角色
     * @return
     */
    @Select("select * from SYS_ROLE")
    @Results({@Result(property = "id",column = "id"),
            @Result(property = "role",column = "role"),
            @Result(property = "description",column = "description"),
            @Result(property = "available",column = "available"),
            @Result(property = "permissions",javaType = List.class,column ="id",
                    many = @Many(select = "com.yxproject.start.mapper.SysPermissionMapper.selectPermissionByRoleId"))})
    public List<SysRole> selectAllRole();

    /**
     * 查询所有可用角色
     * @return
     */
    @Select("select * from SYS_ROLE WHERE AVAILABLE=0")
    public List<SysRole> selectAllActiveRole();

    /**
     * 通过用户id查询角色
     * @param userId
     * @return
     */
    @Select("select sr.id,sr.role from SYS_USER_ROLE sur ,SYS_ROLE sr where sur.ROLE_ID=sr.ID and sur.USER_ID=#{userId}")
    List<SysRole> selectRoleByUserId(@Param("userId") Integer userId);

    /**
     * 通过用户id查询角色
     * @param userId
     * @return
     */
    @Select("select * from SYS_USER_ROLE sur ,SYS_ROLE sr where sur.ROLE_ID=sr.ID and sur.USER_ID=#{userId}")
    @Results({@Result(property = "id",column = "id"),
            @Result(property = "role",column = "role"),
            @Result(property = "description",column = "description"),
            @Result(property = "available",column = "available"),
            @Result(property = "permissions",javaType = List.class,column ="id",
                    many = @Many(select = "com.yxproject.start.mapper.SysPermissionMapper.selectPermissionByRoleId"))})
    List<SysRole> selectRoleAndPermissionByUserId(@Param("userId") Integer userId);


    /**
     * 更新用户的角色
     * @param userId
     * @param roleId
     */
    @Update("update SYS_USER_ROLE SET ROLE_ID=#{roleId} where USER_ID=#{userId}")
    public void updateUserRole(@Param("userId") Integer userId,@Param("roleId")Integer roleId);

    /**
     * 删除角色
     * @param roleId
     */
    @Update("UPDATE SYS_ROLE SET AVAILABLE = 1 WHERE ID=#{roleId}")
    public void delRole(@Param("roleId") Integer roleId);

    /**
     * 启用角色
     * @param roleId
     */
    @Update("UPDATE SYS_ROLE SET AVAILABLE = 0 WHERE ID=#{roleId}")
    public void backRole(@Param("roleId") Integer roleId);

    /**
     * 通过角色id查角色和权限
     * @param roleId
     * @return
     */
    @Select("select * from SYS_ROLE where id=#{roleId}")
    @Results({@Result(property = "id",column = "id"),
            @Result(property = "role",column = "role"),
            @Result(property = "description",column = "description"),
            @Result(property = "available",column = "available"),
            @Result(property = "permissions",javaType = List.class,column ="id",
                    many = @Many(select = "com.yxproject.start.mapper.SysPermissionMapper.selectPermissionByRoleId"))})
    public SysRole selectRoleByRoleId(@Param("roleId") Integer roleId);

    /**
     * 修改角色信息
     * @param sysRole
     */
    @Update("update SYS_ROLE set role=#{role},description=#{description} where id=#{id}")
    public void updateSysRole(SysRole sysRole);

    /**
     * 删除角色权限关系表中旧关系
     * @param roleId
     * @param oldPermissionId
     */
    @Delete("delete from SYS_ROLE_PERMISSION WHERE ROLE_ID=#{roleId} AND PERMISSION_ID=#{oldPermissionId}")
    public void delRolePermission(@Param("roleId") Integer roleId,@Param("oldPermissionId") Integer oldPermissionId);
}
