package com.yxproject.start.entity;

import javax.persistence.*;
import java.sql.Time;
import java.util.Date;
import java.util.Objects;

/**
 * Created by zhangyusheng on 2018/11/16 10:51
 */
@Entity
@Table(name = "COUNTY_LIST", schema = "DAHAI")
public class CountyListEntity {
    private long county_List_Id;
    private long task_Id;
    private Date save_Date;
    private String county_Code;
    private long finish_Count;
    private long in_Storage_Count;
    private long out_Storage_Count;
    @Id
    @Column(name = "COUNTY_LIST_ID", nullable = false, precision = 0)
    public long getCounty_List_Id() {
        return county_List_Id;
    }

    public void setCounty_List_Id(long county_List_Id) {
        this.county_List_Id = county_List_Id;
    }


    @Basic
    @Column(name = "TASK_ID", nullable = false, precision = 0)
    public long getTask_Id() {
        return task_Id;
    }

    public void setTask_Id(long task_Id) {
        this.task_Id = task_Id;
    }

    @Basic
    @Column(name = "SAVE_DATE", nullable = false)
    public Date getSave_Date() {
        return save_Date;
    }

    public void setSave_Date(Date save_Date) {
        this.save_Date = save_Date;
    }

    @Basic
    @Column(name = "COUNTY_CODE", nullable = true, length = 20)
    public String getCounty_Code() {
        return county_Code;
    }

    public void setCounty_Code(String county_Code) {
        this.county_Code = county_Code;
    }

    @Basic
    @Column(name = "FINISH_COUNT", nullable = true, precision = 0)
    public long getFinish_Count() {
        return finish_Count;
    }

    public void setFinish_Count(long finish_Count) {
        this.finish_Count = finish_Count;
    }

    @Basic
    @Column(name = "IN_STORAGE_COUNT", nullable = true, precision = 0)
    public long getIn_Storage_Count() {
        return in_Storage_Count;
    }

    public void setIn_Storage_Count(long in_Storage_Count) {
        this.in_Storage_Count = in_Storage_Count;
    }

    @Basic
    @Column(name = "OUT_STORAGE_COUNT", nullable = true, precision = 0)
    public long getOut_Storage_Count() {
        return out_Storage_Count;
    }

    public void setOut_Storage_Count(long out_Storage_Count) {
        this.out_Storage_Count = out_Storage_Count;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CountyListEntity that = (CountyListEntity) o;
        return county_List_Id == that.county_List_Id &&
                task_Id == that.task_Id &&
                finish_Count == that.finish_Count &&
                in_Storage_Count == that.in_Storage_Count &&
                out_Storage_Count == that.out_Storage_Count &&
                Objects.equals(save_Date, that.save_Date) &&
                Objects.equals(county_Code, that.county_Code);
    }

    @Override
    public int hashCode() {
        return Objects.hash(county_List_Id, task_Id, finish_Count, in_Storage_Count, out_Storage_Count,save_Date,county_Code);
    }

    @Override
    public String toString() {
        return "COUNTY_LIST [county_List_Id=" + county_List_Id + ", task_Id=" + task_Id + ", finish_Count=" + finish_Count + ", in_Storage_Count=" + in_Storage_Count + ", out_Storage_Count=" + out_Storage_Count + ",save_Date=" + save_Date + "county_Code=" + county_Code +" ]";
    }
}
