package com.yxproject.start.api;

import com.yxproject.start.entity.SysPermission;
import com.yxproject.start.entity.SysRole;
import com.yxproject.start.entity.UserInfo;
import com.yxproject.start.service.SysPermissionService;
import com.yxproject.start.service.SysRoleService;
import com.yxproject.start.service.UserInfoService;
import com.yxproject.start.utils.Md5Utils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;


/**
 * @author Administrator
 */
@RestController
@RequestMapping("admin")
@RequiresRoles("admin")
public class AdminApi {

    @Autowired
    private SysPermissionService sysPermissionService;

    @Autowired
    private UserInfoService userInfoService;

    @Autowired
    private SysRoleService sysRoleService;


    @RequestMapping("test")
    public String hello() {
        return "f1";
    }


    /**
     * 获得用户列表
     *
     * @return
     */
    @RequestMapping("getUserList")
    public List<UserInfo> selectAllUser() {
        List<UserInfo> list = userInfoService.getAllUserInfo();
        return list;
    }

    /**
     * 用户添加;
     *
     * @return
     */
    @PostMapping("userAdd")
    public Map<String, String> userInfoAdd(@RequestBody String json) {
        JSONObject jsonObject = JSONObject.fromObject(json);
        String salt = UUID.randomUUID().toString();
        UserInfo userInfo = new UserInfo();
        userInfo.setPassword(Md5Utils.entryptPassword(jsonObject.getString("password"), salt));
        userInfo.setSalt(salt);
        userInfo.setUsername(jsonObject.getString("username"));
        userInfo.setName(jsonObject.getString("name"));
        Map<String, String> map = new HashMap<>();
        boolean flag = false;
        flag = userInfoService.addUser(userInfo, Integer.parseInt(jsonObject.getString("roleId")));
        if (flag) {
            map.put("resultMsg", "添加成功");

        } else {
            map.put("resultMsg", "添加失败");
        }
        return map;
    }

    /**
     * 通过id查询用户;
     *
     * @return
     */
    @RequestMapping(value = "getUserById", method = RequestMethod.GET)
    public Map<String, Object> getUserById(@RequestParam("userId") String userId, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        Map<String, Object> map = new HashMap<>();
        UserInfo userInfo = userInfoService.getUserInfoByUserId(Integer.parseInt(userId));
        map.put("user", userInfo);
        return map;

    }


    /**
     * 用户删除;
     *
     * @return
     */
    @RequestMapping(value = "userDel", method = RequestMethod.GET)
    public Map<String, Object> userInfoDel(@RequestParam("userId") String userId, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        Map<String, Object> map = new HashMap<>();
        boolean flag = false;
        flag = userInfoService.deleteUserInfo(Integer.parseInt(userId));
        if (flag) {
            map.put("returnMsg", "删除成功");
        } else {
            map.put("returnMsg", "删除失败");
        }

        return map;

    }

    /**
     * 用户启用;
     *
     * @return
     */
    @RequestMapping(value = "userBack", method = RequestMethod.GET)
    public Map<String, Object> userInfoBack(@RequestParam("userId") String userId, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        Map<String, Object> map = new HashMap<>();
        boolean flag = false;
        flag = userInfoService.BackUserInfo(Integer.parseInt(userId));
        if (flag) {
            map.put("returnMsg", "启用成功");
        } else {
            map.put("returnMsg", "启用失败");
        }

        return map;

    }


    @RequestMapping("getRoleList")
    public List<SysRole> selectAllRole() {
        List<SysRole> list = sysRoleService.getAllRoleInfo();
        return list;

    }

    @RequestMapping("getPermissionList")
    public List<SysPermission> selectAllPermission() {
        List<SysPermission> list = sysPermissionService.getAllPermission();
        return list;

    }

    /**
     * 权限删除;
     *
     * @return
     */
    @RequestMapping("permissionDel")
    public Map permissionDel(@RequestParam("permissionId") String permissionId, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        Map map = new HashMap();
        boolean flag = false;
        flag = sysPermissionService.deletePermission(Integer.parseInt(permissionId));
        if (flag) {
            map.put("returnMsg", "删除成功");
        } else {
            map.put("returnMsg", "删除失败");
        }
        return map;
    }

    /**
     * 权限启用;
     *
     * @return
     */
    @RequestMapping("permissionOpen")
    public Map permissionBack(@RequestParam("permissionId") String permissionId, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        Map map = new HashMap();
        boolean flag = false;
        flag = sysPermissionService.backPermission(Integer.parseInt(permissionId));
        if (flag) {
            map.put("returnMsg", "启用成功");
        } else {
            map.put("returnMsg", "启用失败");
        }
        return map;
    }

    /**
     * 通过id查询权限;
     *
     * @return
     */
    @RequestMapping(value = "getPermsById", method = RequestMethod.GET)
    public Map<String, Object> getPermsById(@RequestParam("permissionId") String permissionId, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        Map<String, Object> map = new HashMap<>();
        SysPermission sysPermission = sysPermissionService.getPermissionByPId(Integer.parseInt(permissionId));
        map.put("permission", sysPermission);
        return map;

    }

    /**
     * 通过id查询角色;
     *
     * @return
     */
    @RequestMapping(value = "getRoleById", method = RequestMethod.GET)
    public Map<String, Object> getRoleById(@RequestParam("roleId") String roleId, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        Map<String, Object> map = new HashMap<>();
        SysRole sysRole = sysRoleService.getRoleByRoleId(Integer.parseInt(roleId));
        map.put("role", sysRole);
        return map;

    }

    /**
     * 添加权限
     *
     * @param jsonStr
     * @param resp
     * @return
     */
    @RequestMapping(value = "permissionAdd", method = RequestMethod.POST)
    public Map<String, String> userAdd(@RequestBody String jsonStr, HttpServletResponse resp) {
        resp.setCharacterEncoding("UTF-8");
        Map<String, String> map = new HashMap<>();
        JSONObject jsonObject = JSONObject.fromObject(jsonStr);
        boolean flag = false;
        String str = "0";
        SysPermission sysPermission = new SysPermission();
        sysPermission.setName(jsonObject.getString("name"));
        sysPermission.setResource_type(jsonObject.getString("resourceType"));
//        sysPermission.setUrl(jsonObject.getString("url"));
        sysPermission.setPermission(jsonObject.getString("permission"));
//        sysPermission.setParent_id(Long.parseLong(jsonObject.getString("parentId")));
//        if(jsonObject.getString("parentId").equals(str)){
//            sysPermission.setParent_ids(jsonObject.getString("parentId")+"/");
//        }else{
//            sysPermission.setParent_ids(str+"/"+jsonObject.getString("parentId"));
//        }
        System.out.println(sysPermission);
        flag = sysPermissionService.addPermission(sysPermission);
        if (flag) {
            map.put("resultMsg", "添加成功");

        } else {
            map.put("resultMsg", "添加失败");
        }
        return map;

    }


    /**
     * 查询所有非锁定角色;
     *
     * @return
     */

    @RequestMapping(value = "getAllActiveRoleList", method = RequestMethod.GET)
    public List<SysRole> userInfoAdd() {
        List<SysRole> list = sysRoleService.getAllActiveRoleInfo();
        return list;
    }

    /**
     * 查询所有非锁定权限;
     *
     * @return
     */

    @RequestMapping(value = "getAllActivePermissionList", method = RequestMethod.GET)
    public List<SysPermission> getAllActivePermissionList() {
        List<SysPermission> list = sysPermissionService.getAllActivePermission();
        return list;
    }

    /**
     * 角色删除;
     *
     * @return
     */
//    @GET
//    @Path("roleDel")
//    @RequiresPermissions("role.del")
//    public String roleDel(@QueryParam("roleId") String roleId,@Context HttpServletResponse response){
//        response.setCharacterEncoding("UTF-8");
//        Map map = new HashMap();
//        boolean flag = false;
//        flag = sysRoleService.deleteRole(Integer.parseInt(roleId));
//        if(flag){
//            map.put("returnMsg","删除成功");
//        }else{
//            map.put("returnMsg","删除失败");
//        }
//        return map.toString();
//    }


//    @GET
//    @Path("roleBack")
//    public String roleBack(@QueryParam("roleId") String roleId,@Context HttpServletResponse response){
//        response.setCharacterEncoding("UTF-8");
//        Map map = new HashMap();
//        boolean flag = false;
//        flag = sysRoleService.backRole(Integer.parseInt(roleId));
//        if(flag){
//            map.put("returnMsg","启用成功");
//        }else{
//            map.put("returnMsg","启用失败");
//        }
//        return map.toString();
//    }
    @RequestMapping("roleAdd")
    public Map<String, String> roleAdd(@RequestBody String jsonStr, HttpServletResponse resp) {
        resp.setCharacterEncoding("UTF-8");
        Map<String, String> map = new HashMap<>();
        JSONObject jsonObject = JSONObject.fromObject(jsonStr);
        boolean flag = false;
        SysRole sysRole = new SysRole();
        sysRole.setRole(jsonObject.getString("role"));
        sysRole.setDescription(jsonObject.getString("description"));
        String permissionIds = jsonObject.getString("permissionIds");

        JSONArray jsonArray = JSONArray.fromObject(permissionIds);
        flag = sysRoleService.addRole(sysRole, jsonArray);
        if (flag) {
            map.put("resultMsg", "添加成功");

        } else {
            map.put("resultMsg", "添加失败");
        }
        return map;

    }

    @PostMapping("userUpdate")
    public Map<String, String> userInfoUpdate(@RequestBody String json, HttpServletResponse resp) {
        resp.setCharacterEncoding("UTF-8");
        JSONObject jsonObject = JSONObject.fromObject(json);
        UserInfo userInfo = new UserInfo();
        userInfo.setUsername(jsonObject.getString("username"));
        userInfo.setName(jsonObject.getString("name"));
        userInfo.setId(Integer.parseInt(jsonObject.getString("id")));
        Map<String, String> map = new HashMap<>();
        boolean flag = false;
        flag = userInfoService.updateUser(userInfo, Integer.parseInt(jsonObject.getString("roleId")), Integer.parseInt(jsonObject.getString("oldRoleId")));
        if (flag) {
            map.put("resultMsg", "修改成功");

        } else {
            map.put("resultMsg", "修改失败");
        }
        return map;

    }

    @RequestMapping("roleUpdate")
    public Map roleUpdate(@RequestBody String jsonStr, HttpServletResponse resp) {
        resp.setCharacterEncoding("UTF-8");
        Map<String, String> map = new HashMap<>();
        JSONObject jsonObject = JSONObject.fromObject(jsonStr);
        boolean flag = false;
        SysRole sysRole = new SysRole();
        sysRole.setId(Integer.parseInt(jsonObject.getString("roleId")));
        sysRole.setRole(jsonObject.getString("role"));
        sysRole.setDescription(jsonObject.getString("description"));
        String oldPermissionIds = jsonObject.getString("oldPermissionIds");
        JSONArray jsonArrayOldPids = JSONArray.fromObject(oldPermissionIds);
        String permissionIds = jsonObject.getString("permissionId");
        JSONArray jsonArrayPids = JSONArray.fromObject(permissionIds);
        flag = sysRoleService.updateRole(sysRole, jsonArrayPids, jsonArrayOldPids);
        if (flag) {
            map.put("resultMsg", "修改成功");

        } else {
            map.put("resultMsg", "修改失败");
        }
        return map;

    }


    @PostMapping("permissionUpdate")
    public Map<String, String> permissionUpdate(@RequestBody String jsonStr, HttpServletResponse resp) {
        resp.setCharacterEncoding("UTF-8");
        JSONObject jsonObject = JSONObject.fromObject(jsonStr);
        Map<String, String> map = new HashMap<>();
        boolean flag = false;
//        String str = "0";
        SysPermission sysPermission = new SysPermission();
        sysPermission.setId(Integer.parseInt(jsonObject.getString("id")));
        sysPermission.setName(jsonObject.getString("name"));
        sysPermission.setResource_type(jsonObject.getString("resourceType"));
//        sysPermission.setUrl(jsonObject.getString("url"));
        sysPermission.setPermission(jsonObject.getString("permission"));
//        sysPermission.setParent_id(Long.parseLong(parentId));
//        if(parentId.equals(str)){
//            sysPermission.setParent_ids(parentId+"/");
//        }else{
//            sysPermission.setParent_ids(str+"/"+parentId);
//        }
        System.out.println(sysPermission);
        flag = sysPermissionService.updatePermission(sysPermission);
        if (flag) {
            map.put("resultMsg", "修改成功");

        } else {
            map.put("resultMsg", "修改失败");
        }
        return map;

    }








 }
