app.controller('receiptCtrl', ['$scope', '$rootScope', '$http', '$state', '$filter', '$localStorage', 'HttpService', 'ngDialog', function ($scope, $rootScope, $http, $state, $filter, $localStorage, HttpService, $ngDialog) {

    if ($rootScope.loginData.login === false) {
        $state.go("signin")
    } else {
        $state.go("layout.receipt")
    }
    $scope.date = "date";

    //获得当前年月日
    var getNowFormatDetailDate = function () {
        var date = new Date();
        var month = date.getMonth() + 1;
        var strDate = date.getDate();
        var strHours = date.getHours();
        var strMin = date.getMinutes();
        if (month >= 1 && month <= 9) {
            month = "0" + month;
        }
        if (strDate >= 0 && strDate <= 9) {
            strDate = "0" + strDate;
        }
        if (strHours >= 0 && strHours <= 9) {
            strHours = "0" + strHours;
        }
        if (strMin >= 0 && strMin <= 9) {
            strMin = "0" + strMin;
        }
        var currentdate = date.getFullYear() + "" + month + strDate + strHours + strMin;
        return currentdate;
    }
    $scope.currentDetailDate = getNowFormatDetailDate();
    $scope.nowDataEight = new Date().format("yyyy-MM-dd 08:00")
    $scope.nowDate = new Date().format("yyyy-MM-dd hh:mm");

    var changeDataFormat = function (date) {
        var yyyyMMdd = date.split(" ")[0];
        var hhmm = date.split(" ")[1];
        var yyyy = yyyyMMdd.split("-")[0];
        var MM = yyyyMMdd.split("-")[1];
        var dd = yyyyMMdd.split("-")[2];
        var hh = hhmm.split(":")[0];
        var mm = hhmm.split(":")[1];
        return yyyy + MM + dd + hh + mm;
    }

    var getReceiptData = function (startTime, endTime) {

        HttpService.getReceiptData(startTime, endTime, function (data) {
            $scope.receiptData = data.respData;
            console.log($scope.receiptData)
        })
    }
    getReceiptData(changeDataFormat($scope.nowDataEight), changeDataFormat($scope.nowDate))

    $scope.myClick = function () {
        var date1 = $("#wdate1").val();
        var date2 = $("#wdate2").val();
        console.log(changeDataFormat(date1))
        console.log(changeDataFormat(date2))
        getReceiptData(changeDataFormat(date1), changeDataFormat(date2))
    }
    $scope.printReceipt = function () {
        var date1 = $("#wdate1").val();
        var date2 = $("#wdate2").val();
        HttpService.getprintReceipt(changeDataFormat(date1), changeDataFormat(date2), function (data) {
            var blob = new Blob([data], {type: "application/vnd.ms-excel"});
            var a = document.createElement("a");
            document.body.appendChild(a);
            a.href = URL.createObjectURL(blob);
            a.click();
        })
    }
    //下载回执单
    $scope.printOfficialReceipt = function () {
        var date1 = $("#wdate1").val();
        var date2 = $("#wdate2").val();
        HttpService.getPrintOfficialReceipt(changeDataFormat(date1), changeDataFormat(date2), function (data) {
            var blob = new Blob([data], {type: "application/vnd.ms-excel"});
            var a = document.createElement("a");
            document.body.appendChild(a);
            a.href = URL.createObjectURL(blob);
            a.click();
        })
    }


}]);