app.controller('permissionListCtrl', ['$scope', '$rootScope', '$http', '$state', '$filter', '$localStorage', 'HttpService', 'ngDialog',
    function ($scope, $rootScope, $http, $state, $filter, $localStorage, HttpService, ngDialog) {
        if ($rootScope.loginData.login === false) {
            $state.go("signin")
        } else {
            $state.go("layout.permissionList")
        }

        $scope.id = 'id';

        var getPermissionList = function () {
            HttpService.getPermissionListData(function (data) {
                $scope.permissionList = data;
                console.log($scope.permissionList);
            })
        }
        getPermissionList();

        // 删除权限
        $scope.permissionDel = function (id) {
            HttpService.delPermission(id, function (data) {
                getPermissionList();
            })
        }

        // 启用权限
        $scope.permissionOpen = function (id) {
            HttpService.openPermission(id, function (data) {
                getPermissionList();
            })
        }

        // 添加
        $scope.addPerms = function () {
            ngDialog.open({
                template: 'dialogs/addPermission.html' + urlTimeStamp(),
                width: 800,
                cache: false,
                closeByDocument: false,
                controller: ['$scope', 'HttpService', '$rootScope', function ($scope, HttpService) {
                    $scope.permissionAdd = function (resourceType) {
                        var permission = {};
                        permission.name = $scope.name;
                        permission.url = $scope.url;
                        permission.permission = $scope.permission;
                        permission.resourceType = resourceType;
                        console.log(permission)
                        HttpService.addPermission(permission, function (data) {
                            $scope.closeThisDialog();
                            getPermissionList();
                        })
                    }
                }]
            })
        }
        // 修改
        $scope.updatePerms = function (id) {
            ngDialog.open({
                template: 'dialogs/updatePerms.html' + urlTimeStamp(),
                width: 800,
                cache: false,
                closeByDocument: false,
                controller: ['$scope', 'HttpService', '$rootScope', function ($scope, HttpService) {
                    HttpService.getPermsById(id, function (data) {
                        $scope.thisPerm = data.permission;
                        console.log($scope.thisPerm)
                    })
                    $scope.permUpdate = function (resourceType) {
                        var jsonPerm = {};
                        jsonPerm.id = $scope.thisPerm.id;
                        jsonPerm.name = $scope.thisPerm.name;
                        // jsonPerm.url=$scope.thisPerm.url;
                        jsonPerm.permission = $scope.thisPerm.permission;
                        jsonPerm.resourceType = resourceType;
                        console.log(jsonPerm)
                        HttpService.updatePerm(jsonPerm, function (data) {
                            $scope.closeThisDialog();
                            getPermissionList();
                        })
                    }
                }]

            })

        }


    }])