'use strict';

/**
 * Config for the router
 */
angular.module('app')
  .config(
    [          '$stateProvider', '$urlRouterProvider',
      function ($stateProvider,   $urlRouterProvider) {
          
          $urlRouterProvider
              .otherwise('/layout/welcome');
          $stateProvider
              .state('signin', {
                  url: '/signin',
                  templateUrl: 'tpl/signin/signin.html',
                  cache:false,
                  resolve: {
                      deps: ['uiLoad',
                        function( uiLoad ){
                          return uiLoad.load( ['tpl/signin/signin.js'] );
                      }]
                  }
              })
              .state('layout', {
                  url: '/layout',
                  templateUrl: 'tpl/layout/layout.html',
                  cache:false,
                  controller:'layOutCtrl',
                  resolve: {
                      deps: ['uiLoad',
                          function( uiLoad ){
                              return uiLoad.load( ['tpl/layout/layout.js'] );
                          }]
                  }
              })
              .state('layout.cycleSheet', {
                  url: '/cycleSheet',
                  templateUrl: 'tpl/layout/cycleSheet/cycleSheet.html',
                  cache:false,
                  controller:'cycleSheetCtrl',
                  resolve: {
                      deps: ['uiLoad',
                        function( uiLoad ){
                          return uiLoad.load( ['tpl/layout/cycleSheet/cycleSheet.js'] );
                      }]
                  }
              })
              .state('layout.yieldReport', {
                  url: '/yieldReport',
                  templateUrl: 'tpl/layout/yieldReport/yieldReport.html',
                  cache:false,
                  controller:'yieldReportCtrl',
                  resolve: {
                      deps: ['uiLoad',
                          function( uiLoad ){
                              return uiLoad.load( ['tpl/layout/yieldReport/yieldReport.js'] );
                          }]
                  }
              })
              .state('layout.userList', {
                  url: '/userList',
                  templateUrl: 'tpl/layout/userList/userList.html',
                  cache:false,
                  controller:'userListCtrl',
                  resolve: {
                      deps: ['uiLoad',
                          function( uiLoad ){
                              return uiLoad.load( ['tpl/layout/userList/userList.js'] );
                          }]
                  }
              })
              .state('layout.roleList', {
                  url: '/roleList',
                  templateUrl: 'tpl/layout/roleList/roleList.html',
                  cache:false,
                  controller:'roleListCtrl',
                  resolve: {
                      deps: ['uiLoad',
                          function( uiLoad ){
                              return uiLoad.load( ['tpl/layout/roleList/roleList.js'] );
                          }]
                  }
              })
              .state('layout.permissionList', {
                  url: '/permissionList',
                  templateUrl: 'tpl/layout/permissionList/permissionList.html',
                  cache:false,
                  controller:'permissionListCtrl',
                  resolve: {
                      deps: ['uiLoad',
                          function( uiLoad ){
                              return uiLoad.load( ['tpl/layout/permissionList/permissionList.js'] );
                          }]
                  }
              })
              .state('layout.welcome', {
                  url: '/welcome',
                  templateUrl: 'tpl/layout/welcome/welcome.html',
                  cache:false,
                  controller:'welcomeCtrl',
                  resolve: {
                      deps: ['uiLoad',
                          function( uiLoad ){
                              return uiLoad.load( ['tpl/layout/welcome/welcome.js'] );
                          }]
                  }
              })
              .state('layout.searchSpecialCard', {
                  url: '/searchSpecialCard',
                  templateUrl: 'tpl/layout/searchSpecialCard/searchSpecialCard.html',
                  cache:false,
                  controller:'searchSpecialCardCtrl',
                  resolve: {
                      deps: ['uiLoad',
                          function( uiLoad ){
                              return uiLoad.load( ['tpl/layout/searchSpecialCard/searchSpecialCard.js'] );
                          }]
                  }
              })
              .state('layout.failedCard', {
                  url: '/failedCard',
                  templateUrl: 'tpl/layout/failedCard/failedCard.html',
                  cache:false,
                  controller:'failedCardCtrl',
                  resolve: {
                      deps: ['uiLoad',
                          function( uiLoad ){
                              return uiLoad.load( ['tpl/layout/failedCard/failedCard.js'] );
                          }]
                  }
              })
              .state('layout.receipt', {
                  url: '/receipt',
                  templateUrl: 'tpl/layout/receipt/receipt.html',
                  cache:false,
                  controller:'receiptCtrl',
                  resolve: {
                      deps: ['uiLoad',
                          function( uiLoad ){
                              return uiLoad.load( ['tpl/layout/receipt/receipt.js'] );
                          }]
                  }
              })

      }
    ]
  );