package com.yxproject.start.service.impl;

import com.yxproject.start.entity.*;
import com.yxproject.start.entity.accu.AccCardTEntity;
import com.yxproject.start.entity.prod.ProdCardTEntity;
import com.yxproject.start.mapper.*;
import com.yxproject.start.entity.CountyListEntity;
import com.yxproject.start.service.TaskService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @author Administrator
 */
@Service
public class TaskServiceImpl implements TaskService {

    @Autowired
    public TaskMapper taskMapper;

    @Autowired
    public GroupNoMapper groupNoMapper;

    @Autowired
    public UtilMapper utilMapper;

    @Autowired
    public AccCardTMapper accCardTMapper;

    @Autowired
    public ProdCardTMapper prodCardTMapper;

    @Autowired
    public PoliceStationVailedMapper policeStationVailedMapper;

    @Autowired
    public SpecialCardMapper specialCardMapper;



    /**
     * 查询任务单
     * 通过任务单ID
     *
     * @param id
     * @return
     */
    @Override
    public List<TaskEntity> findProductionTaskListEntityByID(long id) {
        return taskMapper.findTaskEntity(id);
    }

    /**
     * 更新任务单信息
     * 通过新的任务单信息
     *
     * @param taskEntity
     * @return
     */
    @Override
    public int updateProductionTask( TaskEntity taskEntity ) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddhhmmss");
        //todo  状态更新时间
        Long state = taskEntity.getTask_State_Id();
        switch (Integer.valueOf(state.toString())) {
            case 1:
                taskEntity.setIssued_Date(new Date());
                break;
            case 2:
                taskEntity.setDownload_Date(new Date());
                break;
            case 3:
                taskEntity.setPrint_Out_Date(new Date());
                taskEntity.setPrint_State((long)3);
                break;
            case 4:
                taskEntity.setPosition_Date(new Date());
                break;
            case 5:
                taskEntity.setOut_Workshop_Date(new Date());
                break;
            case 6:
                taskEntity.setQuality_Test_Date(new Date());
                break;
            case 7:
                taskEntity.setIn_Storage_Date(new Date());
                break;
            case 8:
                taskEntity.setOut_Storage_Date(new Date());
                break;
            default:
                break;
        }
        return taskMapper.updateTaskEntity(taskEntity);
    }

    /**
     * 生成任务单并保存组号列表
     *
     * @param taskEntity 任务单详情
     * @param groupNoEntities        组号列表
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int addProductionTaskListEntity(TaskEntity taskEntity, List<GroupNoEntity> groupNoEntities) {

        int production_task_list_seq = utilMapper.findProductionTaskListSequenceNextValue();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        taskMapper.insertTaskEntity(taskEntity);
        for (GroupNoEntity groupNoEntity : groupNoEntities) {
            groupNoMapper.insertGroupNoEntity(groupNoEntity);
        }

        return 1;
    }

    /**
     * 查询证件信息（搜索框）
     * 包括受理库、制证库的证件信息，以及该证件所在任务单的详细情况
     *
     * @param cardInfo
     * @return
     */
    @Override
    public List<Object> findCardInfoByCardIDOrAcceptNo(String cardInfo) {
        List<Object> list = new ArrayList<>();
        String accept_no = "";
        List<AccCardTEntity> accCardTEntityByCardIdOrAcceptNo = accCardTMapper.findAccCardTEntityByCardIdOrAcceptNo(cardInfo);
        if (accCardTEntityByCardIdOrAcceptNo.size() != 0) {
            list.addAll(accCardTEntityByCardIdOrAcceptNo);
            for (AccCardTEntity accCardTEntity : accCardTEntityByCardIdOrAcceptNo) {
                accept_no = accCardTEntity.getAccept_No();
            }
        }
        List<ProdCardTEntity> prodCardTEntityByCardIdOrAcceptNo = prodCardTMapper.findCardInfo(cardInfo);
        if (prodCardTEntityByCardIdOrAcceptNo.size() != 0) {
            list.addAll(prodCardTEntityByCardIdOrAcceptNo);
            for (ProdCardTEntity prodCardTEntity : prodCardTEntityByCardIdOrAcceptNo) {
                accept_no = prodCardTEntity.getAccept_No();
            }
        }
        List<TaskEntity> productionTaskListEntityByAcceptNo = taskMapper.findTaskEntityByAcceptNo(accept_no);
        list.addAll(productionTaskListEntityByAcceptNo);
        return list;
    }

    /**
     * 添加快证
     * 包含已经下发的任务单、没有下发的任务单
     *
     * @param cardInfo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int addQuickCyclesheetInfo(String cardInfo) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        /**
         * 查询证件的受理号
         */
        String accept_no = "";
        List<AccCardTEntity> accCardTEntityByCardIdOrAcceptNo = accCardTMapper.findAccCardTEntityByCardIdOrAcceptNo(cardInfo);
        if (accCardTEntityByCardIdOrAcceptNo.size() != 0) {
            for (AccCardTEntity accCardTEntity : accCardTEntityByCardIdOrAcceptNo) {
                accept_no = accCardTEntity.getAccept_No();
            }
        }
        List<ProdCardTEntity> prodCardTEntityByCardIdOrAcceptNo = prodCardTMapper.findCardInfo(cardInfo);
        if (prodCardTEntityByCardIdOrAcceptNo.size() != 0) {
            for (ProdCardTEntity prodCardTEntity : prodCardTEntityByCardIdOrAcceptNo) {
                accept_no = prodCardTEntity.getAccept_No();
            }
        }
        List<GroupNoEntity> groupNoEntityByAcceptNo = groupNoMapper.findGroupNoEntityByAcceptNo(accept_no);
        List<SpecialCardEntity> specialCardEntities = specialCardMapper.findSpecialCardEntityByAcceptNo(accept_no);
        /**
         * 没有下发任务单的情况
         * 即 在组号列表中没有没有该受理组号
         */
        if (groupNoEntityByAcceptNo.size() == 0) {
            List<Map<String, Object>> entity = accCardTMapper.findAccGroupTEntityByCardIdOrAcceptNo(accept_no);
            for (Map<String, Object> map : entity) {
                Object group_no = map.get("GROUP_NO");
                Object valid_count = map.get("VALID_COUNT");
                Object invalid_count = map.get("INVALID_COUNT");
                Object original_no = map.get("ORIGINAL_NO");
                /**
                 * 生成原来的任务单 但不下发
                 */
                TaskEntity taskEntity = new TaskEntity();
                int production_task_list_seq = utilMapper.findProductionTaskListSequenceNextValue();
                taskEntity.setCitycode(original_no.toString().substring(0, 6));
                taskEntity.setCard_Type(Long.valueOf(original_no.toString().substring(20, 21)));
                taskEntity.setSubmit_Date(new Date());
                taskMapper.insertTaskEntity(taskEntity);
                /**
                 * 生成原来任务单的组号列表
                 * 原组号
                 */
                int groupInfoSequenceValue = utilMapper.findGroupInfoSequenceNextValue();
                GroupNoEntity groupNoEntity = new GroupNoEntity();
                groupNoEntity.setTask_Id(taskEntity.getTask_Id());
                GroupNoEntity groupNoEntity1 = new GroupNoEntity();
                groupNoEntity1.setTask_Id(taskEntity.getTask_Id());
                groupNoEntity1.setGroup_No(group_no.toString());
                groupNoEntity1.setInvalid_Count(Long.valueOf(invalid_count.toString()));
                groupNoEntity1.setValid_Count(Long.valueOf(valid_count.toString()));
                groupNoEntity1.setSpecial_Card_Count((long) 1);
                groupNoMapper.insertGroupNoEntity(groupNoEntity1);


                /**
                 * 生成快证任务单并下发
                 */
                TaskEntity taskEntity1 = new TaskEntity();
                taskEntity1.setCitycode(original_no.toString().substring(0, 6));
                taskEntity1.setCard_Type((long) 1);
                taskEntity1.setOld_Card_Type(Long.valueOf(original_no.toString().substring(20, 21)));
                taskEntity1.setSubmit_Date(new Date());
                taskEntity1.setIssued_Date(new Date());
                taskMapper.insertTaskEntity(taskEntity1);
//                /**
//                 * 生成快证任务单的组号列表
//                 * 快证组号
//                 */
//                int groupInfoSequenceValueQ = utilMapper.findGroupInfoSequenceNextValue();
//                GroupinfoEntity groupinfoEntityQ = new GroupinfoEntity();
//                groupinfoEntityQ.setGroupid(simpleDateFormat.format(new Date())+groupInfoSequenceValueQ);
//                groupinfoEntityQ.setCyclesheetid(simpleDateFormat.format(new Date())+production_task_list_seqQ);
//                groupinfoEntityQ.setGroupno(accept_no);
//                groupinfoEntityQ.setInvalid_Count((long)0);
//                groupinfoEntityQ.setValid_Count((long)1);
//                groupinfoMapper.insertGroupinfoEntity(groupinfoEntityQ);
                /**
                 * 生成快证任务单的受理号信息
                 */
                int acceptInfoSequenceNextValue = utilMapper.findAcceptInfoSequenceNextValue();
                SpecialCardEntity specialCardEntity = new SpecialCardEntity();
                specialCardEntity.setAccept_No(accept_no);
                //设置受理类型为快证
                specialCardEntity.setSpecial_Type((long) 1);
                specialCardEntity.setTask_Id(taskEntity1.getTask_Id());
                specialCardEntity.setGroup_No(accept_no.substring(0, 8));
                specialCardMapper.saveSpecialCardEntity(specialCardEntity);
            }
        } else if (groupNoEntityByAcceptNo.size() == 1 && specialCardEntities.size() == 0) {
            /**
             * 下发任务单 但没有产生余证的情况
             * 即 只有一个受理组号
             */
            List<TaskEntity> taskEntities = taskMapper.findTaskEntity(groupNoEntityByAcceptNo.get(0).getTask_Id());
//            /**
//             * 从原来的任务单中减去快证
//             * 即从原来任务单组号列表中插入一条-1的组号
//             */
//            int groupInfoSequenceValue2 = utilMapper.findGroupInfoSequenceNextValue();
//            GroupinfoEntity groupinfoEntity2 = new GroupinfoEntity();
//            groupinfoEntity2.setGroupid(simpleDateFormat.format(new Date())+groupInfoSequenceValue2);
//            groupinfoEntity2.setCyclesheetid(productionTaskListEntity.get(0).getProduction_Task_List_Id());
//            groupinfoEntity2.setGroupno(accept_no);
//            groupinfoEntity2.setInvalid_Count((long)0);
//            groupinfoEntity2.setValid_Count((long)-1);
//            groupinfoMapper.insertGroupinfoEntity(groupinfoEntity2);
            /**
             * 更新组号信息表中的特殊证数量
             */
            GroupNoEntity groupNoEntity = groupNoEntityByAcceptNo.get(1);
            groupNoEntity.setSpecial_Card_Count(groupNoEntity.getSpecial_Card_Count() + 1);
            groupNoMapper.updateGroupinfoEntity(groupNoEntity);
            /**
             * 生成快证任务单并下发
             */
            TaskEntity taskEntity = new TaskEntity();
            taskEntity.setCitycode(taskEntities.get(0).getCitycode());
            taskEntity.setCard_Type((long) 1);
            taskEntity.setOld_Card_Type(taskEntities.get(0).getCard_Type());
            taskEntity.setSubmit_Date(new Date());
            taskEntity.setIssued_Date(new Date());
            taskMapper.insertTaskEntity(taskEntity);
//            /**
//             * 生成快证任务单的组号列表
//             * 快证组号
//             */
//            int groupInfoSequenceValueQ = utilMapper.findGroupInfoSequenceNextValue();
//            GroupinfoEntity groupinfoEntityQ = new GroupinfoEntity();
//            groupinfoEntityQ.setGroupid(simpleDateFormat.format(new Date())+groupInfoSequenceValueQ);
//            groupinfoEntityQ.setCyclesheetid(simpleDateFormat.format(new Date())+production_task_list_seqQ);
//            groupinfoEntityQ.setGroupno(accept_no);
//            groupinfoEntityQ.setGrouptype((long)1);
//            groupinfoEntityQ.setInvalid_Count((long)0);
//            groupinfoEntityQ.setValid_Count((long)1);
//            groupinfoMapper.insertGroupinfoEntity(groupinfoEntityQ);
            /**
             * 生成快证任务单的受理号信息
             */
            int acceptInfoSequenceNextValue = utilMapper.findAcceptInfoSequenceNextValue();
            SpecialCardEntity specialCardEntity = new SpecialCardEntity();
            specialCardEntity.setAccept_No(accept_no);
            //设置受理类型为快证
            specialCardEntity.setSpecial_Type((long) 1);
            specialCardEntity.setTask_Id(taskEntity.getTask_Id());
            specialCardEntity.setGroup_No(accept_no.substring(0, 8));
            specialCardMapper.saveSpecialCardEntity(specialCardEntity);
        } else {
//            /**
//             * 下发任务单 存在产生余证的情况
//             *即更新组号列表的组号类型
//             * 以及更新余证任务单的制证类型和原制证类型
//             */
//            List<GroupinfoEntity> groupinfoEntities = groupinfoMapper.findGroupinfoEntityByAcceptNo(accept_no);
//            for (GroupinfoEntity groupinfoEntity:groupinfoEntities){
//                /*
//                找到余证任务单  并更新制证类型和原制证类型
//                 */
//                if (accept_no.equals(groupinfoEntity.getGroupno()) &&groupinfoEntity.getValid_Count()==1){
//                    /**
//                     * 找到余证任务单
//                     */
//                    List<ProductionTaskListEntity> productionTaskListEntities = productionTaskListMapper.findProductionTaskListEntity(groupinfoEntity.getCyclesheetid());
//                    for (ProductionTaskListEntity productionTaskListEntity:productionTaskListEntities){
//                        productionTaskListEntity.setOld_Make_Type(productionTaskListEntity.getMake_Type());
//                        productionTaskListEntity.setMake_Type((long)1);
//                        productionTaskListMapper.updateProductionTask(productionTaskListEntity);
//                    }
//                    groupinfoEntity.setGrouptype((long)1);
//                    groupinfoMapper.updateGroupinfoEntity(groupinfoEntity);
//                }else if (accept_no.equals(groupinfoEntity.getGroupno())){
//                    groupinfoEntity.setGrouptype((long)1);
//                    groupinfoMapper.updateGroupinfoEntity(groupinfoEntity);
//                }
//            }
            /**
             * 下发任务单 存在产生余证的情况
             * 更新余证任务单的制证类型以及更新受理号信息的受理类型
             */
            List<TaskEntity> productionTaskListEntities = taskMapper.findTaskEntity(groupNoEntityByAcceptNo.get(0).getTask_Id());
            for (TaskEntity productionTaskListEntity : productionTaskListEntities) {
                productionTaskListEntity.setOld_Card_Type(productionTaskListEntity.getCard_Type());
                productionTaskListEntity.setCard_Type((long) 1);
                taskMapper.updateTaskEntity(productionTaskListEntity);
            }
            for (SpecialCardEntity specialCardEntity : specialCardEntities) {
                specialCardEntity.setSpecial_Type((long) 1);
                specialCardMapper.updateSpecialCardEntity(specialCardEntity);
            }
        }
        return 1;
    }

    /**
     * 查询受理库制证信息
     * 按查询处理时间
     *
     * @param importDate
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<Object> findAccuProductionInfo(String importDate) {
        return new ArrayList<>();
    }

    /**
     * 保持派出所照片质量详情
     *
     * @param policeStationVailedInfoEntityList
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int savePoliceStationVailedEntity(List<PoliceStationVailedEntity> policeStationVailedInfoEntityList) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        for (PoliceStationVailedEntity policeEntity : policeStationVailedInfoEntityList) {
            policeStationVailedMapper.savePoliceStationVailedInfoEntity(policeEntity);
        }
        return 1;
    }

    /**
     * 查询任务单详情
     * 通过查询任务单状态
     *
     * @param state
     * @return
     */
    @Override
    public List<Map<String, Object>> findProductionTaskListEntityByState(int state) {
        List<TaskEntity> productionTaskListEntities = taskMapper.findTaskEntityByState(state);
        List<Map<String, Object>> productionTaskMapList = new ArrayList<>();
        for (TaskEntity taskEntity : productionTaskListEntities) {
            Map<String, Object> map = new HashMap<>();
            map.put("productionTaskListEntity", taskEntity);
            List<Map<String, Object>> groupinfoMapList = new ArrayList<>();
            List<GroupNoEntity> groupNoEntityListByTaskId = groupNoMapper.findGroupNoEntityListByTaskId(taskEntity.getTask_Id());

            for (GroupNoEntity groupNoEntity : groupNoEntityListByTaskId) {
                Map<String, Object> groupinfoMap = new HashMap<>();
                groupinfoMap.put("groupinfoEntity", groupNoEntity);
                List<SpecialCardEntity> specialCardEntities = specialCardMapper.findSpecialCardEntityByGroupNo(groupNoEntity.getGroup_No());
                groupinfoMap.put("acceptNoInfoEntity", specialCardEntities);
                groupinfoMapList.add(groupinfoMap);
            }
            map.put("groupinfoMapList", groupinfoMapList);
            productionTaskMapList.add(map);
        }


        return null;
    }

    /**
     * 更新任务单
     * 更新异常状态
     * @param
     * @return
     */
    @Override
    public int addExceptionState(TaskEntity taskEntity) {
        int i =0;
        if(taskEntity.getException_Information()!=null) {
            taskEntity.setIs_Exception((long)1);
            i=taskMapper.updateTaskEntity(taskEntity);

        } else {
            taskEntity.setIs_Exception((long)0);
            i=taskMapper.replaceExceptionInformation(taskEntity);
        }
        return i;
    }

    /**
     * 更新出入库时间
     * @param
     * @return
     */
    @Override
    public int updateStorageDate(String taskListId,String inStorageCount,String outStorageCount ) {
        int i=0;
        i= taskMapper.totalNum(i);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddhhmmss");
        if (inStorageCount.equals(i)){
            return taskMapper.updateInStorageDate(taskListId,inStorageCount,outStorageCount);
        }
        if(outStorageCount.equals(i)){
            return taskMapper.updateOutStorageDate(taskListId,inStorageCount,outStorageCount);
        }
        return 0;
    }


    /**
     * 测试查询
     *
     * @param id
     * @return
     */
    @Override
    public List<PoliceStationVailedEntity> find(String id) {
        List<PoliceStationVailedEntity> policeStationVailedInfoEntityByID = policeStationVailedMapper.findPoliceStationVailedEntity(id);
        return policeStationVailedInfoEntityByID;
    }
}
