package com.yxproject.start.service.impl;

import com.yxproject.start.entity.GroupListEntity;
import com.yxproject.start.entity.SpecialCardEntity;
import com.yxproject.start.mapper.GroupNoMapper;
import com.yxproject.start.mapper.SpecialCardMapper;
import com.yxproject.start.service.GroupListService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


import java.util.List;

/**
 * Created by Administrator on 2018/12/18.
 */
@Service
public class GroupListServiceImpl implements GroupListService {
    @Autowired
    public GroupNoMapper groupNoMapper;
    @Autowired
    public SpecialCardMapper specialCardMapper;

    @Override
    public List<GroupListEntity> findGroupListByTaskListId( String taskListId) {
        List <GroupListEntity> groupList=groupNoMapper.findGroupListByTaskListId(taskListId);
        for ( GroupListEntity groupListEntity:groupList) {
            List <SpecialCardEntity> specialCardEntities=specialCardMapper.findSpecialCardList(groupListEntity.getGroupNo()+"");
            groupListEntity.setSpecialCardList(specialCardEntities);
        }
        return  groupList;
    }

    @Override
    public List <GroupListEntity> findGroupListByTaskStateId(String taskStateId) {
        List<GroupListEntity> byTaskStateId = groupNoMapper.findGroupListByTaskStateId(taskStateId);
        for ( GroupListEntity groupListEntity:byTaskStateId) {
            List <SpecialCardEntity> specialCardEntities=specialCardMapper.findSpecialCardList(groupListEntity.getGroupNo()+"");
            groupListEntity.setSpecialCardList(specialCardEntities);
        }
        return byTaskStateId;
    }

    @Override
    public List <GroupListEntity> findGroupListByCardType( String cardType ) {
        List<GroupListEntity> byCardType = groupNoMapper.findGroupListByCardType(cardType);
        for ( GroupListEntity groupListEntity:byCardType) {
            List <SpecialCardEntity> specialCardEntities=specialCardMapper.findSpecialCardList(groupListEntity.getGroupNo()+"");
            groupListEntity.setSpecialCardList(specialCardEntities);
        }
        return byCardType;
    }
}
