package com.yxproject.start.entity.accu;

import javax.persistence.*;
import java.sql.Time;
import java.util.Objects;

@Entity
@Table(name = "ACC_GROUP_T", schema = "ACC_DBA", catalog = "")
public class AccGroupTEntity {
    private String group_No;
    private String user_Code;
    private Time import_Time;
    private String deal_Flag;
    private Byte valid_Count;
    private Byte invalid_Count;
    private Time submit_Date;
    private String submit_Code;

    @Id
    @Column(name = "GROUP_NO", nullable = false, length = 10)
    public String getGroup_No() {
        return group_No;
    }

    public void setGroup_No(String group_No) {
        this.group_No = group_No;
    }

    @Basic
    @Column(name = "USER_CODE", nullable = true, length = 8)
    public String getUser_Code() {
        return user_Code;
    }

    public void setUser_Code(String user_Code) {
        this.user_Code = user_Code;
    }

    @Basic
    @Column(name = "IMPORT_TIME", nullable = true)
    public Time getImport_Time() {
        return import_Time;
    }

    public void setImport_Time(Time import_Time) {
        this.import_Time = import_Time;
    }

    @Basic
    @Column(name = "DEAL_FLAG", nullable = false, length = 1)
    public String getDeal_Flag() {
        return deal_Flag;
    }

    public void setDeal_Flag(String deal_Flag) {
        this.deal_Flag = deal_Flag;
    }

    @Basic
    @Column(name = "VALID_COUNT", nullable = true, precision = 0)
    public Byte getValid_Count() {
        return valid_Count;
    }

    public void setValid_Count(Byte valid_Count) {
        this.valid_Count = valid_Count;
    }

    @Basic
    @Column(name = "INVALID_COUNT", nullable = true, precision = 0)
    public Byte getInvalid_Count() {
        return invalid_Count;
    }

    public void setInvalid_Count(Byte invalid_Count) {
        this.invalid_Count = invalid_Count;
    }

    @Basic
    @Column(name = "SUBMIT_DATE", nullable = true)
    public Time getSubmit_Date() {
        return submit_Date;
    }

    public void setSubmit_Date(Time submit_Date) {
        this.submit_Date = submit_Date;
    }

    @Basic
    @Column(name = "SUBMIT_CODE", nullable = true, length = 8)
    public String getSubmit_Code() {
        return submit_Code;
    }

    public void setSubmit_Code(String submit_Code) {
        this.submit_Code = submit_Code;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AccGroupTEntity that = (AccGroupTEntity) o;
        return Objects.equals(group_No, that.group_No) &&
                Objects.equals(user_Code, that.user_Code) &&
                Objects.equals(import_Time, that.import_Time) &&
                Objects.equals(deal_Flag, that.deal_Flag) &&
                Objects.equals(valid_Count, that.valid_Count) &&
                Objects.equals(invalid_Count, that.invalid_Count) &&
                Objects.equals(submit_Date, that.submit_Date) &&
                Objects.equals(submit_Code, that.submit_Code);
    }

    @Override
    public int hashCode() {
        return Objects.hash(group_No, user_Code, import_Time, deal_Flag, valid_Count, invalid_Count, submit_Date, submit_Code);
    }
}
