package com.yxproject.start.entity;

/**
 * Created by Administrator on 2018/12/18.
 */

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@Entity
@Table(name = "TYPE_LIST", schema = "DAHAI")
public class GroupListEntity implements Serializable {
    private long groupNo;
    private long validCount;
    private long invalidCount;
    private long specialCardCount;
    @Transient
    private List<SpecialCardEntity> specialCardList = new ArrayList <SpecialCardEntity>();

    @Id
    @Column(name = "groupNo", nullable = false, precision = 0)
    public long getGroupNo() {
        return groupNo;
    }
    public void setGroupNo(long groupNo) {
        this.groupNo = groupNo;
    }

    @Basic
    @Column(name = "validCount", nullable = true, precision = 0)
    public long getValidCount() {
        return validCount;
    }
    public void setValidCount(long validCount) {
        this.validCount = validCount;
    }

    @Basic
    @Column(name = "invalidCount", nullable = true, precision = 0)
    public long getInvalidCount() {
        return invalidCount;
    }
    public void setInvalidCount(long invalidCount) {
        this.invalidCount = invalidCount;
    }

    @Basic
    @Column(name = "specialCardCount", nullable = true, precision = 0)
    public long getSpecialCardCount() {
        return specialCardCount;
    }
    public void setSpecialCardCount(long specialCardCount) {
        this.specialCardCount = specialCardCount;
    }

    @Transient
    public List <SpecialCardEntity > getSpecialCardList() {
        return specialCardList;
    }
    public void setSpecialCardList( List <SpecialCardEntity> specialCardList ) {
        this.specialCardList = specialCardList;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GroupListEntity that = (GroupListEntity) o;
        return groupNo == that.groupNo &&
                validCount == that.validCount &&
                invalidCount == that.invalidCount &&
                specialCardCount == that.specialCardCount;
    }

    @Override
    public int hashCode() {
        return Objects.hash(groupNo, validCount,invalidCount,specialCardCount);
    }


}
