package com.yxproject.start.entity;

import javax.persistence.*;

/**
 * Created by Administrator on 2018/11/21.
 */
@Entity
@Table(name = "ACC_GROUP_RELATION_T", schema = "ACC_DBA", catalog = "")
public class AccGroupRelationTEntity {
    private String groupNo;
    private String originalNo;
    private String dealStatus;
    private String dealDate;
    private String uploadUnitNo;

    @Id
    @Column(name = "GROUP_NO", nullable = false, length = 10)
    public String getGroupNo() {
        return groupNo;
    }

    public void setGroupNo(String groupNo) {
        this.groupNo = groupNo;
    }

    @Basic
    @Column(name = "ORIGINAL_NO", nullable = false, length = 25)
    public String getOriginalNo() {
        return originalNo;
    }

    public void setOriginalNo(String originalNo) {
        this.originalNo = originalNo;
    }

    @Basic
    @Column(name = "DEAL_STATUS", nullable = true, length = 1)
    public String getDealStatus() {
        return dealStatus;
    }

    public void setDealStatus(String dealStatus) {
        this.dealStatus = dealStatus;
    }

    @Basic
    @Column(name = "DEAL_DATE", nullable = false, length = 8)
    public String getDealDate() {
        return dealDate;
    }

    public void setDealDate(String dealDate) {
        this.dealDate = dealDate;
    }

    @Basic
    @Column(name = "UPLOAD_UNIT_NO", nullable = false, length = 12)
    public String getUploadUnitNo() {
        return uploadUnitNo;
    }

    public void setUploadUnitNo(String uploadUnitNo) {
        this.uploadUnitNo = uploadUnitNo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AccGroupRelationTEntity that = (AccGroupRelationTEntity) o;

        if (groupNo != null ? !groupNo.equals(that.groupNo) : that.groupNo != null) return false;
        if (originalNo != null ? !originalNo.equals(that.originalNo) : that.originalNo != null) return false;
        if (dealStatus != null ? !dealStatus.equals(that.dealStatus) : that.dealStatus != null) return false;
        if (dealDate != null ? !dealDate.equals(that.dealDate) : that.dealDate != null) return false;
        if (uploadUnitNo != null ? !uploadUnitNo.equals(that.uploadUnitNo) : that.uploadUnitNo != null) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = groupNo != null ? groupNo.hashCode() : 0;
        result = 31 * result + (originalNo != null ? originalNo.hashCode() : 0);
        result = 31 * result + (dealStatus != null ? dealStatus.hashCode() : 0);
        result = 31 * result + (dealDate != null ? dealDate.hashCode() : 0);
        result = 31 * result + (uploadUnitNo != null ? uploadUnitNo.hashCode() : 0);
        return result;
    }
}
