/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.nio.ByteBuffer;
import java.util.EnumSet;
import oracle.jdbc.dcn.RowChangeDescription;
import oracle.jdbc.dcn.TableChangeDescription;
import oracle.jdbc.driver.NTFDCNRowChanges;
import oracle.sql.CharacterSet;

class NTFDCNTableChanges
implements TableChangeDescription {
    final EnumSet<TableChangeDescription.TableOperation> opcode;
    String tableName;
    final int objectNumber;
    final int numberOfRows;
    final RowChangeDescription.RowOperation[] rowOpcode;
    final int[] rowIdLength;
    final byte[][] rowid;
    final CharacterSet charset;
    NTFDCNRowChanges[] rowsDescription = null;
    private static final byte OPERATION_ANY = 0;
    private static final byte OPERATION_UNKNOWN = 64;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_26_18:10:24_PDT_2010";
    public static final boolean TRACE = false;

    NTFDCNTableChanges(ByteBuffer byteBuffer, int n2) {
        this.charset = CharacterSet.make(n2);
        this.opcode = TableChangeDescription.TableOperation.getTableOperations(byteBuffer.getInt());
        short s2 = byteBuffer.getShort();
        byte[] byArray = new byte[s2];
        byteBuffer.get(byArray, 0, s2);
        this.tableName = this.charset.toStringWithReplacement(byArray, 0, s2);
        this.objectNumber = byteBuffer.getInt();
        if (!this.opcode.contains((Object)TableChangeDescription.TableOperation.ALL_ROWS)) {
            this.numberOfRows = byteBuffer.getShort();
            this.rowOpcode = new RowChangeDescription.RowOperation[this.numberOfRows];
            this.rowIdLength = new int[this.numberOfRows];
            this.rowid = new byte[this.numberOfRows][];
            for (int i2 = 0; i2 < this.numberOfRows; ++i2) {
                this.rowOpcode[i2] = RowChangeDescription.RowOperation.getRowOperation(byteBuffer.getInt());
                this.rowIdLength[i2] = byteBuffer.getShort();
                this.rowid[i2] = new byte[this.rowIdLength[i2]];
                byteBuffer.get(this.rowid[i2], 0, this.rowIdLength[i2]);
            }
        } else {
            this.numberOfRows = 0;
            this.rowid = null;
            this.rowOpcode = null;
            this.rowIdLength = null;
        }
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public int getObjectNumber() {
        return this.objectNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowChangeDescription[] getRowChangeDescription() {
        if (this.rowsDescription == null) {
            NTFDCNTableChanges nTFDCNTableChanges = this;
            synchronized (nTFDCNTableChanges) {
                if (this.rowsDescription == null) {
                    this.rowsDescription = new NTFDCNRowChanges[this.numberOfRows];
                    for (int i2 = 0; i2 < this.rowsDescription.length; ++i2) {
                        this.rowsDescription[i2] = new NTFDCNRowChanges(this.rowOpcode[i2], this.rowIdLength[i2], this.rowid[i2]);
                    }
                }
            }
        }
        return this.rowsDescription;
    }

    @Override
    public EnumSet<TableChangeDescription.TableOperation> getTableOperations() {
        return this.opcode;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    operation=" + this.getTableOperations() + ", tableName=" + this.tableName + ", objectNumber=" + this.objectNumber + "\n");
        RowChangeDescription[] rowChangeDescriptionArray = this.getRowChangeDescription();
        if (rowChangeDescriptionArray != null && rowChangeDescriptionArray.length > 0) {
            stringBuffer.append("    Row Change Description (length=" + rowChangeDescriptionArray.length + "):\n");
            for (int i2 = 0; i2 < rowChangeDescriptionArray.length; ++i2) {
                stringBuffer.append(rowChangeDescriptionArray[i2].toString());
            }
        }
        return stringBuffer.toString();
    }
}

