app.controller('roleListCtrl', ['$scope','$rootScope', '$http', '$state', '$filter','$localStorage','HttpService','ngDialog',
       function($scope,$rootScope, $http,$state, $filter,$localStorage,HttpService,ngDialog){

    if($rootScope.loginData.login === false){
        $state.go("signin")
    }else {
        $state.go("layout.roleList")
    }

    $scope.id = 'id';

    var getRoleList = function(){
        HttpService.getRoleListData(function(data) {
            $scope.roleList = data;
            console.log($scope.roleList);
        })
    }
    getRoleList();

    $scope.addRole = function(){
        ngDialog.open({
            template: 'dialogs/addRole.html' + urlTimeStamp(),
            width:600,
            cache: false,
            closeByDocument:false,
            controller: ['$scope', 'HttpService', '$rootScope', function ($scope, HttpService) {
                HttpService.getAllActivePermissionList(function(data) {
                    $scope.activePermissionList = data;
                })
                $scope.roleAdd = function(permissionId){
                    var permission={};
                    permission.role=$scope.role;
                    permission.description=$scope.description;
                    permission.permissionIds=permissionId;
                    console.log(permission)
                    HttpService.rolesAdd(permission,function(data){
                        $scope.closeThisDialog();
                        getRoleList();
                    })
                }

            }]

        })
    }


    $scope.updateRoles = function(id){
        ngDialog.open({
            template: 'dialogs/updateRole.html' + urlTimeStamp(),
            width:800,
            cache: false,
            closeByDocument:false,
            controller: ['$scope', 'HttpService', '$rootScope', function ($scope, HttpService) {
                HttpService.getRoleById(id,function(data){
                    $scope.thisRole = data.role;
                    console.log($scope.thisRole)
                })
                HttpService.getAllActivePermissionList(function(data) {
                    $scope.activePermissionList = data;
                })
                $scope.roleUpdate = function(permissionId){
                    var jsonRole = {};
                    jsonRole.oldPermissionIds=[];
                    jsonRole.role=$scope.thisRole.role;
                    jsonRole.roleId =$scope.thisRole.id;
                    jsonRole.description =$scope.thisRole.description;
                    for (var i=0;i<$scope.thisRole.permissions.length;i++){
                        jsonRole.oldPermissionIds.push($scope.thisRole.permissions[i].id);
                    }
                    jsonRole.permissionId=permissionId;
                    console.log(jsonRole)
                    HttpService.updateRole(jsonRole,function(data){
                        $scope.closeThisDialog();
                        getRoleList();
                    })
                }
            }]

        })
    }

}])