package com.yxproject.start.service.impl;

import com.yxproject.start.entity.PoliceStationApplyReasonEntity;
import com.yxproject.start.mapper.GroupNoMapper;
import com.yxproject.start.mapper.PoliceStationApplyReasonMapper;
import com.yxproject.start.mapper.UtilMapper;
import com.yxproject.start.service.PoliceStationApplyReasonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by zhangyusheng on 2018/11/12 14:28
 */
@Service
public class PoliceStationApplyReasonServiceImpl implements PoliceStationApplyReasonService {
    @Autowired
    private PoliceStationApplyReasonMapper policeStationApplyReasonMapper;
    @Autowired
    private GroupNoMapper groupinfoMapper;
    @Autowired
    private UtilMapper utilMapper;

    @Override
    @Transactional(rollbackFor=Exception.class)
    public int savePoliceStationApplyReasonEntity(String cyclesheetid) {

        int count = groupinfoMapper.findGroupNoCountByTaskId(cyclesheetid);
        List<Map<String,Object>> list = new ArrayList<>();
        if (count==0){
            list = policeStationApplyReasonMapper.findSpecialApplyReasonByCyclesheetID(cyclesheetid);
        }else{
            list = policeStationApplyReasonMapper.findNormalApplyReasonByCyclesheetID(cyclesheetid);
        }
        for (Map<String,Object> map :list){
            PoliceStationApplyReasonEntity policeStationApplyReasonEntity = new PoliceStationApplyReasonEntity();
            policeStationApplyReasonEntity.setTask_Id(Long.valueOf(cyclesheetid));
            policeStationApplyReasonEntity.setSave_Date(new Date());
            policeStationApplyReasonEntity.setApply_Count(Long.valueOf(map.get("APPLY_COUNT").toString()));
            policeStationApplyReasonEntity.setApply_Code(Long.valueOf(map.get("APPLY_CODE").toString()));
            policeStationApplyReasonEntity.setPolice_Station_Code(map.get("POLICE_STATION_CODE").toString());
            policeStationApplyReasonMapper.savePoliceStationApplyReasonEntity(policeStationApplyReasonEntity);
        }
        return 1;
    }
    /**
     * 查询派出所申领表通过保存时间;
     * @param
     * @return
     */
    @Override
    public List <Map <String, Object>> findPoliceStationApplyReasonBySaveDate( String saveDate ) {
        List <Map <String, Object>> SaveData =policeStationApplyReasonMapper.findPoliceStationApplyReasonBySaveDate(saveDate);
        return SaveData;
    }

    /**
     * 查询派出所申领表通过制证类型;
     * @param
     * @return
     */
    @Override
    public List <Map <String, Object>> findPoliceStationApplyReasonByCardType(String cardType) {
        List <Map <String, Object>> CardType =policeStationApplyReasonMapper.findPoliceStationApplyReasonByCardType(cardType);
        return CardType;
    }

    /**
     * 查询派出所申领表通过地市;
     * @param
     * @return
     */
    @Override
    public List <Map <String, Object>> findPoliceStationApplyReasonByCity(String city) {
        List <Map <String, Object>> City =policeStationApplyReasonMapper.findPoliceStationApplyReasonByCity(city);
        return City;
    }

    /**
     * 查询派出所申领表通过区县;
     * @param
     * @return
     */
    @Override
    public List <Map <String, Object>> findPoliceStationApplyReasonByCounty(String county) {
        List <Map <String, Object>> County =policeStationApplyReasonMapper.findPoliceStationApplyReasonByCounty(county);
        return County;
    }

    /**
     * 查询派出所申领表通过派出所;
     * @param
     * @return
     */
    @Override
    public List <Map <String, Object>> findPoliceStationApplyReasonByGajgMC(String gajgMC) {
        List <Map <String, Object>> GajgMC =policeStationApplyReasonMapper.findPoliceStationApplyReasonByGajgMC(gajgMC);
        return GajgMC;
    }
}
