package com.yxproject.start.service.impl;

import com.yxproject.start.entity.GroupNoEntity;
import com.yxproject.start.mapper.GroupNoMapper;
import com.yxproject.start.service.GroupNoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by zhangyusheng on 2018/11/1 14:26
 */
@Service
public class GroupNoServiceImpl implements GroupNoService {
    @Autowired
    public GroupNoMapper groupNoMapper;

    @Override
    public List<Map<String, Object>> findCountyInfoList(String cyclesheetid) {
        int count = groupNoMapper.findGroupNoCountByTaskId(cyclesheetid);
        List<Map<String,Object>> list = new ArrayList<>();
        if (count==0){
            list = groupNoMapper.findSpecialCountyList(cyclesheetid);
        }else{
            list = groupNoMapper.findNormalCountyList(cyclesheetid);
        }
        return list;
    }

    @Override
    public List<GroupNoEntity> findGroupNoByTaskListID( String tasklistid) {
        List<GroupNoEntity> byTaskListID = groupNoMapper.findGroupNoByTaskListID(tasklistid);
        return  byTaskListID;
    }

    @Override
    public List <GroupNoEntity> findGroupNoByTaskStateId(String taskStateId) {
        List<GroupNoEntity> TaskStateId = groupNoMapper.findGroupNoByTaskStateId(taskStateId);
        return TaskStateId;
    }

    @Override
    public List <GroupNoEntity> findGroupNoByCardType( String cardType ) {
        List<GroupNoEntity> CardType = groupNoMapper.findGroupNoByCardType(cardType);
        return CardType;
    }

}
