package com.yxproject.start.service.impl;

import com.yxproject.start.entity.CountyListEntity;
import com.yxproject.start.mapper.CountyListMapper;
import com.yxproject.start.service.CountyListService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by liuxinben on 2018/11/6.13:42
 */

@Service
public class CountyListServiceImpl implements CountyListService {
    @Autowired
    public CountyListMapper countyListMapper;

    @Override
    public List<CountyListEntity> findCountyListByTaskListID(String tasklistid) {
        List<CountyListEntity> byTaskListID = countyListMapper.findCountyListByTaskListID(tasklistid);
        return  byTaskListID;
    }

    @Override
    public List <CountyListEntity> findCountyListByTaskStateId(String taskStateId) {
        List<CountyListEntity> TaskStateId = countyListMapper.findCountyListByTaskStateId(taskStateId);
        return TaskStateId;
    }

    @Override
    public List <CountyListEntity> findCountyListByCardType( String cardType ) {
        List<CountyListEntity> CardType = countyListMapper.findCountyListByCardType(cardType);
        return CardType;
    }

    @Override
    public int reviseOutBoundCount(CountyListEntity countyListEntity) {
        countyListEntity.setOut_Storage_Count(countyListEntity.getOut_Storage_Count());
        return countyListMapper.updateBoundCount(countyListEntity);
    }

    @Override
    public int reviseInBoundCount(CountyListEntity countyListEntity) {
        countyListEntity.setIn_Storage_Count(countyListEntity.getIn_Storage_Count());
        return countyListMapper.updateBoundCount(countyListEntity);
    }

    @Override
    public List<Map<String, Object>> getConnectList(String save_Date) {
        return countyListMapper.getConnectList(save_Date);
    }


}