package com.yxproject.start.entity.prod;

import javax.persistence.*;
import java.util.Objects;

@Entity
@Table(name = "PROD_APPLY_INFO_T", schema = "PROD_DBA", catalog = "")
public class ProdApplyInfoTEntity {
    private String upload_No;
    private String accept_No;
    private String make_Type;
    private String apply_Name;
    private String apply_Phone;
    private String apply_Postcode;
    private String apply_Address;
    private String draw_Type;
    private String province_No;

    @Basic
    @Column(name = "UPLOAD_NO", nullable = false, length = 22)
    public String getUpload_No() {
        return upload_No;
    }

    public void setUpload_No(String upload_No) {
        this.upload_No = upload_No;
    }

    @Id
    @Column(name = "ACCEPT_NO", nullable = false, length = 12)
    public String getAccept_No() {
        return accept_No;
    }

    public void setAccept_No(String accept_No) {
        this.accept_No = accept_No;
    }

    @Basic
    @Column(name = "MAKE_TYPE", nullable = true, length = 1)
    public String getMake_Type() {
        return make_Type;
    }

    public void setMake_Type(String make_Type) {
        this.make_Type = make_Type;
    }

    @Basic
    @Column(name = "APPLY_NAME", nullable = true, length = 45)
    public String getApply_Name() {
        return apply_Name;
    }

    public void setApply_Name(String apply_Name) {
        this.apply_Name = apply_Name;
    }

    @Basic
    @Column(name = "APPLY_PHONE", nullable = true, length = 20)
    public String getApply_Phone() {
        return apply_Phone;
    }

    public void setApply_Phone(String apply_Phone) {
        this.apply_Phone = apply_Phone;
    }

    @Basic
    @Column(name = "APPLY_POSTCODE", nullable = true, length = 6)
    public String getApply_Postcode() {
        return apply_Postcode;
    }

    public void setApply_Postcode(String apply_Postcode) {
        this.apply_Postcode = apply_Postcode;
    }

    @Basic
    @Column(name = "APPLY_ADDRESS", nullable = true, length = 105)
    public String getApply_Address() {
        return apply_Address;
    }

    public void setApply_Address(String apply_Address) {
        this.apply_Address = apply_Address;
    }

    @Basic
    @Column(name = "DRAW_TYPE", nullable = false, length = 2)
    public String getDraw_Type() {
        return draw_Type;
    }

    public void setDraw_Type(String draw_Type) {
        this.draw_Type = draw_Type;
    }

    @Basic
    @Column(name = "PROVINCE_NO", nullable = true, length = 6)
    public String getProvince_No() {
        return province_No;
    }

    public void setProvince_No(String province_No) {
        this.province_No = province_No;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ProdApplyInfoTEntity that = (ProdApplyInfoTEntity) o;
        return Objects.equals(upload_No, that.upload_No) &&
                Objects.equals(accept_No, that.accept_No) &&
                Objects.equals(make_Type, that.make_Type) &&
                Objects.equals(apply_Name, that.apply_Name) &&
                Objects.equals(apply_Phone, that.apply_Phone) &&
                Objects.equals(apply_Postcode, that.apply_Postcode) &&
                Objects.equals(apply_Address, that.apply_Address) &&
                Objects.equals(draw_Type, that.draw_Type) &&
                Objects.equals(province_No, that.province_No);
    }

    @Override
    public int hashCode() {
        return Objects.hash(upload_No, accept_No, make_Type, apply_Name, apply_Phone, apply_Postcode, apply_Address, draw_Type, province_No);
    }
}
