/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T2CConnection;

class T2CInputStream
extends OracleInputStream {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_26_18:10:24_PDT_2010";
    public static final boolean TRACE = false;

    native int t2cGetBytes(long var1, int var3, byte[] var4, int var5, Accessor[] var6, byte[] var7, int var8, char[] var9, int var10, short[] var11, int var12, Object[] var13, Object[] var14, long var15);

    T2CInputStream(OracleStatement oracleStatement, int n2, Accessor accessor) {
        super(oracleStatement, n2, accessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBytes(int n2) throws IOException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            if (n2 > this.currentBufferSize) {
                this.currentBufferSize = Math.max(n2, this.initialBufferSize);
                this.resizableBuffer = new byte[this.currentBufferSize];
            }
            long l2 = this.statement.connection.useNio ? 1 : 0;
            if (this.statement.connection.useNio) {
                if (this.statement.nioBuffers[3] == null || this.statement.nioBuffers[3].capacity() < this.resizableBuffer.length) {
                    this.statement.nioBuffers[3] = ByteBuffer.allocateDirect(this.resizableBuffer.length);
                } else {
                    this.statement.nioBuffers[3].rewind();
                }
            }
            int n3 = this.t2cGetBytes(this.statement.c_state, this.columnIndex, this.resizableBuffer, this.currentBufferSize, this.statement.accessors, this.statement.defineBytes, this.statement.accessorByteOffset, this.statement.defineChars, this.statement.accessorCharOffset, this.statement.defineIndicators, this.statement.accessorShortOffset, this.statement.nioBuffers, this.statement.lobPrefetchMetaData, l2);
            boolean bl = false;
            try {
                if (n3 == -1) {
                    ((T2CConnection)this.statement.connection).checkError(n3, this.statement.sqlWarning);
                } else if (n3 == -2) {
                    bl = true;
                    this.accessor.setNull(this.statement.currentRow == -1 ? 0 : this.statement.currentRow, true);
                    n3 = 0;
                } else if (this.statement.connection.useNio && n3 >= 0) {
                    this.accessor.setNull(this.statement.currentRow == -1 ? 0 : this.statement.currentRow, false);
                }
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.getMessage());
            }
            if (n3 <= 0) {
                n3 = -1;
                bl = true;
            }
            if (this.statement.connection.useNio) {
                ByteBuffer byteBuffer = this.statement.nioBuffers[3];
                if (byteBuffer != null && n3 > 0) {
                    byteBuffer.get(this.resizableBuffer, 0, n3);
                }
                if (bl) {
                    try {
                        this.statement.extractNioDefineBuffers(this.columnIndex);
                    }
                    catch (SQLException sQLException) {
                        throw new IOException(sQLException.getMessage());
                    }
                }
            }
            if (bl && this.statement.lobPrefetchMetaData != null) {
                this.statement.processLobPrefetchMetaData(this.statement.lobPrefetchMetaData);
            }
            return n3;
        }
    }
}

