package com.yingxin.springcloudauthserver.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.config.annotation.configurers.ClientDetailsServiceConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableAuthorizationServer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerEndpointsConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.token.store.InMemoryTokenStore;
import org.springframework.security.oauth2.provider.token.store.redis.RedisTokenStore;

// 定义授权服务器
@Configuration
@EnableAuthorizationServer
public class AuthorizationServerConfig extends AuthorizationServerConfigurerAdapter {

    private final AuthenticationManager authenticationManager;
    private final RedisConnectionFactory redisConnectionFactory;

    public AuthorizationServerConfig(AuthenticationManager authenticationManager, RedisConnectionFactory redisConnectionFactory) {
        this.authenticationManager = authenticationManager;
        this.redisConnectionFactory = redisConnectionFactory;
    }

//    @Bean
//    public PasswordEncoder passwordEncoder() {
//        return PasswordEncoderFactories.createDelegatingPasswordEncoder();
//    }

    // 定义令牌端点上的安全性约束
    @Override
    public void configure(AuthorizationServerSecurityConfigurer security) {
        security.allowFormAuthenticationForClients()
                .tokenKeyAccess("permitAll()")
//                .checkTokenAccess("permitAll()");
                .checkTokenAccess("isAuthenticated()");
    }

    // 定义客户端详细信息服务的配置器。可以初始化客户端详细信息，也可以只引用现有store
    @Override
    public void configure(ClientDetailsServiceConfigurer clients) throws Exception {
        // 2.0版本以后默认取消了明文密码保存
        String finalSecret = "{bcrypt}" + new BCryptPasswordEncoder().encode("1234567");
        /*
        client模式，没有用户的概念，直接与认证服务器交互，用配置中的客户端信息去申请accessToken，
            客户端有自己的client_id,client_secret对应于用户的username,password，而客户端也拥有自己的
            authorities，当采取client模式认证时，对应的权限也就是客户端自己的authorities。
        password模式，自己本身有一套用户体系，在认证时需要带上自己的用户名和密码，
            以及客户端的client_id,client_secret。此时，accessToken所包含的权限是用户本身的权限，
            而不是客户端的权限。
         */
        clients.inMemory().withClient("client_1")//                clientId：（必须）客户端id
                .authorizedGrantTypes("client_credentials", "refresh_token")
                .secret(finalSecret)
        .and().withClient("client_2")
//                .resourceIds("order") // resorceIds：这个客户端可以访问的资源id 不设置则授权所有资源
                .authorizedGrantTypes("password", "refresh_token") // 授权给客户端使用的权限类型 默认值为空
                .scopes("server") // 客户端的作用域。如果scope未定义或者为空（默认值），则客户端作用域不受限制
                .authorities("oauth2") // 授权给客户端的权限
                .secret(finalSecret); // （对于可信任的客户端是必须的）客户端的私密信息
    }

    // 定义授权和令牌端点以及令牌服务
    @Override
    public void configure(AuthorizationServerEndpointsConfigurer endpoints) {
        endpoints
                .tokenStore(new RedisTokenStore(redisConnectionFactory))
//                .tokenStore(new InMemoryTokenStore())
                .authenticationManager(authenticationManager)
                .allowedTokenEndpointRequestMethods(HttpMethod.GET, HttpMethod.POST); // 默认只开放post请求
    }
}
