package com.legalPersonMonitor.verification.impl;

import cn.com.jit.assp.css.client.util.Base64;
import cn.com.jit.assp.dsign.DSign;
import com.legalPersonMonitor.verification.VerificationI;

import java.util.Arrays;

public class OldVerificationImpl implements VerificationI {

    @Override
    public  boolean signCheck(byte[] dataPackage) {
        byte[] dataLengthByte = Arrays.copyOfRange(dataPackage, 6, 10);
        // 数据区长度
        int dataLength =getIntFromBytes(dataLengthByte);
        // 被签名数据
        byte[] data = Arrays.copyOfRange(dataPackage, 0, 10 + dataLength);
        // 签名长度数据
        byte[] signatureLengthByte = Arrays.copyOfRange(dataPackage, 10 + dataLength, 11 + dataLength);
        // 签名长度
        int signatureLength = signatureLengthByte[0];
        // 签名数据
        byte[] signatureByte = Arrays.copyOfRange(dataPackage, 11 + dataLength, 11 + dataLength + signatureLength);
        // 证书
        byte[] zhengshu = Arrays.copyOfRange(data, data.length - 32, data.length);
        DSign ds = new DSign();
        DSign.init("./config/cssconfig.properties");
        String certID = new String(zhengshu).trim();
        String strDigetsAlg = "sm3";
        long a = ds.p1Verify(certID, strDigetsAlg, Base64.encode(signatureByte), data);
        if (a == 0) {
            return true;
        }
        return false;
    }
    public static int getIntFromBytes(byte[] bytes) {
        return (0xff & bytes[0]) | (0xff00 & (bytes[1] << 8))
                | (0xff0000 & (bytes[2] << 16))
                | (0xff000000 & (bytes[3] << 24));
    }

}
