package com.legalPersonMonitor.monitor;

import com.legalPersonMonitor.auth.Authentication;
import com.legalPersonMonitor.config.ParameterConfig;
import com.legalPersonMonitor.connections.SocketSender;
import com.legalPersonMonitor.data.AuthApplyRetainBean;
import com.legalPersonMonitor.data.AuthRequestBean;
import com.legalPersonMonitor.data.AuthResponseBean;
import com.legalPersonMonitor.utils.FormatBytesUtil;
import net.sf.json.JSONObject;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by gaoxiang on 2018/1/22.
 * 可信平台状态监控
 */
public class TrustedPlatformStatusMonitoring {
    private  String msgDescription = "";

    public  String trustedPlatformStatusMonitoringServer() {
        try {
            byte[] preAuthSendSocketData = SocketSender.sendSocketPackage(ParameterConfig.PREAUTH_BYTE);
            if (preAuthSendSocketData != null) {
                byte[] businessSerialNumberByte = Arrays.copyOfRange(preAuthSendSocketData, 24, 33);
                String businessSerialNumber = FormatBytesUtil.bytesToHexString(businessSerialNumberByte);
                JSONObject jsonObject = JSONObject.fromObject(ParameterConfig.AUTH_JSONSTR);
                Map config = new HashMap();
                config.put("authApplyRetainData", AuthApplyRetainBean.class);
                AuthRequestBean authRequestBean = (AuthRequestBean) JSONObject.toBean(jsonObject, AuthRequestBean.class, config);
                authRequestBean.setBusinessSerialNumber(businessSerialNumber);
                byte[] responseBean = new Authentication().authExecute(authRequestBean);
                byte[] authSendSocketData = SocketSender.sendSocketPackage(responseBean);
                if (authSendSocketData != null) {
                    msgDescription = new String(Arrays.copyOfRange(authSendSocketData, 33, 37));
                }
            }
        }catch (Exception e){
            msgDescription="连接超时";
        }
        return msgDescription;
    }

}



