package com.legalPersonMonitor.data;



import com.legalPersonMonitor.config.ParameterConfig;
import com.legalPersonMonitor.signature.SignatureI;
import com.legalPersonMonitor.signature.impl.OldSignatureImpl;
import com.legalPersonMonitor.utils.FormatBytesUtil;

public class SocketPackage {
	private byte[] version;
	private byte[] commandType;
	private byte[] command;
	private byte[] commandContent;
	private byte[] operation;
	// 数据区长度 4字节
	private byte[] dataLength;
	private byte[] data;
	// 签名长度 1字节
	private byte[] signatureLength;
	// 签名 变长
	private byte[] signature;

	/**
	 *
	 * @param version 协议版本 2字节 0x0001
	 * @param commandType 命令类型 1字节 0x00(请求)0x01(应答)
	 * @param command 命令 1字节 0x00(身份认证申请)0x01(身份认证)
	 * @param commandContent 命令内容 1字节 保留 0x00
	 * @param operation 操作 1字节 保留 0x00
	 * @param data 数据区 变长
	 */
	public SocketPackage(byte[] version, byte[] commandType, byte[] command, byte[] commandContent, byte[] operation,
                         byte[] data) {
		super();
		this.version = version;
		this.commandType = commandType;
		this.command = command;
		this.commandContent = commandContent;
		this.operation = operation;
		this.dataLength = FormatBytesUtil.getBytesOfInt(data.length);
		this.data = data;
	}

	public byte[] getSocketPackage() {
		SignatureI oldSignatureImpl=new OldSignatureImpl();
		byte[] clearText = FormatBytesUtil.concatAll(version, commandType, command, commandContent, operation,
				dataLength, data);
		byte[] cipherText = oldSignatureImpl.signature(ParameterConfig.strDN, ParameterConfig.strDigestAlg,clearText);
		this.signatureLength = new byte[] { (byte) cipherText.length };
		this.signature = cipherText;
		byte[] socketPackage = FormatBytesUtil.concatAll(clearText, signatureLength, signature);
		return socketPackage;
	}

}
