package com.legalPersonMonitor.data;

import com.legalPersonMonitor.encryption.EncryptionI;
import com.legalPersonMonitor.encryption.impl.OldEncryptionImpl;
import com.legalPersonMonitor.utils.FormatBytesUtil;

import java.io.UnsupportedEncodingException;

public class RetainData {
	// 姓名
	private String name;
	// 身份证号
	private String idNumber;
	// 有效期起
	private String validFrom;
	// 有效期止
	private String validEnd;
	/*
	 * 网站上传信息 JSON字符串 必填 String jsonStr =
	 * "{'vendorIp':'202.211.100.100','venderName':'rzfw','businessType':'test','dealDate':'20161202'}";
	 */
	private byte[] updataInfo_JSON = new byte[] { 123, 39, 118, 101, 110, 100, 111, 114, 73, 112, 39, 58, 39, 50, 48,
			50, 46, 50, 49, 49, 46, 49, 48, 48, 46, 49, 48, 48, 39, 44, 39, 118, 101, 110, 100, 101, 114, 78, 97, 109,
			101, 39, 58, 39, 121, 105, 110, 103, 120, 105, 110, 105, 110, 102, 111, 39, 44, 39, 98, 117, 115, 105, 110,
			101, 115, 115, 84, 121, 112, 101, 39, 58, 39, 116, 101, 115, 116, 39, 44, 39, 100, 101, 97, 108, 68, 97,
			116, 101, 39, 58, 39, 50, 48, 49, 54, 49, 50, 48, 50, 39, 125 };
String json="";


	public RetainData(String name, String idNumber, String validFrom, String validEnd) {
		super();
		this.name = name;
		this.idNumber = idNumber;
		this.validFrom = validFrom;
		this.validEnd = validEnd;
	}

	public byte[] getReservasionBytes() {
		EncryptionI oldEncryptionImpl=new OldEncryptionImpl();
		// 各项信息长度固定
		byte[] nameByte = new byte[45];
		byte[] idNumberByte = new byte[18];
		byte[] validFromByte = new byte[8];
		byte[] validEndByte = new byte[8];
		try {
			// 姓名以UTF-8格式转换为byte[]
			nameByte = FormatBytesUtil.copyByteToAnother(nameByte, name.getBytes("UTF-8"));

		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
			return null;
		}
		// 身份证号中含有字母"X"的，一律大写
		idNumberByte = FormatBytesUtil.getBytesFromString(idNumberByte, idNumber);
		if (validFrom != null) {
			validFromByte = FormatBytesUtil.getBytesFromString(validFromByte, validFrom);
		}
		if (validEnd != null) {
			validEndByte = FormatBytesUtil.getBytesFromString(validEndByte, validEnd);
		}
		byte[] bytes = FormatBytesUtil.concatAll(nameByte, idNumberByte, validFromByte, validEndByte, updataInfo_JSON);
		byte[] reservasionBytes = oldEncryptionImpl.getEncryption(bytes);
		return reservasionBytes;
	}

}
