package com.legalPersonMonitor.data;
import com.legalPersonMonitor.utils.FormatBytesUtil;

public class AuthData {
	/**
	 * lengthOfTwo ID验证数据字段及认证吗数据字段总长 2字节
	 * lengthOfIdCheck ID验证数据长度 2字节
	 * lengthOfAuthCodeData 认证码数据长度 2字节
	 * lengthOfPicture 照片长度 4字节
	 * lengthOfReservasion 认证申请保留数据长度 2字节
	 */

	private byte[] lengthOfTwo;
	private byte[] lengthOfIdCheck;
	private byte[] lengthOfAuthCodeData;
	private byte[] lengthOfPicture;
	private byte[] lengthOfReservasion;

	private byte[] customerId;
	private byte[] terminalId;
	private byte[] timestamp;
	private byte[] streamNumber;
	private byte[] identityModel;
	private byte[] idCheckData;
	private byte[] authCodeData;
	private byte[] pictureData;
	private byte[] reservationData;
	private byte[] certificateNumber;

	/**
	 *
	 * @param customerId 客户号 8字节
	 * @param terminalId 终端号 2字节
	 * @param timestamp 时间戳 4字节
	 * @param streamNumber 业务流水号 9字节
	 * @param identityModel 认证模式 1字节
	 * @param idCheckData ID验证数据 变长 可为空
	 * @param authCodeData 认证码数据 变长 可为空
	 * @param pictureData 照片数据 变长 可为空
	 * @param reservationData 认证申请保留数据 变长 可为空
	 * @param certificateNumber 证书序列号 32字节
	 */
	public AuthData(byte[] customerId, byte[] terminalId, byte[] timestamp, byte[] streamNumber, byte[] identityModel,
					byte[] idCheckData, byte[] authCodeData, byte[] pictureData, byte[] reservationData, byte[] certificateNumber) {
		super();
		this.customerId = customerId;
		this.terminalId = terminalId;
		this.timestamp = timestamp;
		this.streamNumber = streamNumber;
		this.identityModel = identityModel;
		int idCheckLengthTemp = 0;
		int verificationLengthTemp = 0;
		this.lengthOfIdCheck = new byte[] { 0, 0 };
		if (idCheckData != null) {
			idCheckLengthTemp = idCheckData.length;
			this.lengthOfIdCheck = FormatBytesUtil.getByteOfShort((short) idCheckData.length);
		}
		this.idCheckData = idCheckData;
		this.lengthOfAuthCodeData = new byte[] { 0, 0 };
		if (authCodeData != null) {
			verificationLengthTemp = authCodeData.length;
			this.lengthOfAuthCodeData = FormatBytesUtil.getByteOfShort((short) authCodeData.length);
		}
		this.authCodeData = authCodeData;
		this.lengthOfTwo = FormatBytesUtil.getByteOfShort((short) (idCheckLengthTemp + verificationLengthTemp + 4));
		this.lengthOfPicture = new byte[] { 0, 0, 0, 0 };
		if (pictureData != null) {
			this.lengthOfPicture = FormatBytesUtil.getBytesOfInt(pictureData.length);
		}
		this.pictureData = pictureData;
		this.lengthOfReservasion = new byte[] { 0, 0 };
		if (reservationData != null) {
			this.lengthOfReservasion = FormatBytesUtil.getByteOfShort((short) reservationData.length);
		}
		this.reservationData = reservationData;
		this.certificateNumber = certificateNumber;
	}

	public byte[] getAuthenticationData() {
		byte[] data = FormatBytesUtil.concatAll(customerId, terminalId, timestamp, streamNumber, identityModel,
				lengthOfTwo, lengthOfIdCheck, idCheckData, lengthOfAuthCodeData, authCodeData, lengthOfPicture, pictureData,
				lengthOfReservasion, reservationData, certificateNumber);
		return data;
	}
}
